package com.pcloud.book.group.entity;

import com.pcloud.common.entity.BaseEntity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 自有码H5页面(ResourcePage)实体类
 *
 * @author makejava
 * @since 2021-03-26 15:25:28
 */
@Data
public class ResourcePage extends BaseEntity {
    private static final long serialVersionUID = 220369810358566952L;
    /**
    * rays码id
    */
    private Long bookGroupId;
    /**
    * 风格类型（1默认2艺术3插画）
    */
    private Integer style;
    /**
    * 是否显示图书信息
    */
    private Integer showBook;
    /**
    * 是否开启小睿流程
    */
    private Integer openRays;
    /**
     * 是否开启世间食记
     */
    private Integer openFood;
    /**
     * 创建人
     */
    private Long createUser;
    /**
     * 预览二维码
     */
    private String qrcodeUrl;
    /**
     * 二维码id
     */
    private Long sceneId;
    /**
     * 公众号二维码id
     */
    private Long officialSceneId;
    /**
     * 自定义配置的图书封面
     */
    private String bookCover;

    /**
     * 书刊id
     */
    private Long bookId;
    /**
     * 渠道id
     */
    private Long channelId;
    /**
     * 背景图
     */
    private String backgroundImg;
    /**
     * 导航颜色样式
     */
    private Integer navigationColor;
    /**
     * 导航版式
     */
    private Integer navigationFormat;
    /**
     * 字体颜色
     */
    private String fontColor;

    /**
     * 图书印章
     */
    private String watermark;
    /**
     * 图书印章样式
     */
    private Integer watermarkStyle;

    @ApiModelProperty("RAYS码落地页类型1本书服务2企微")
    private Integer landingPageType;
    /**
     * 透明度
     */
    private Integer transparency;

    /**
     * 导航使用场景；1：菜单切换；2：功能跳转
     */
    private Integer navigationJumpType;

    /**
     * 是否展示价格
     */
    private Integer isShowPrice;
}
