package com.pcloud.book.recommend.entity;

import java.util.Date;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 基于书的推荐(BookRecommend)实体类
 *
 * @author makejava
 * @since 2021-10-29 15:21:53
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonInclude(JsonInclude.Include.NON_NULL)
public class BookRecommend extends BaseEntity {

    private static final long serialVersionUID = 780912455843928302L;
    
    @ApiModelProperty("书刊id")
    private Long bookId;
    
    @ApiModelProperty("编辑id")
    private Long adviserId;
    
    @ApiModelProperty("渠道id")
    private Integer channelId;
    
    @ApiModelProperty("推荐类型")
    private Integer resourceLimitType;
    
    @ApiModelProperty("推荐id集合")
    private String recommendList;
    
    @ApiModelProperty("修改时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
    
}