/**
 * 
 */
package com.pcloud.common.core.facade;

import org.codehaus.jackson.JsonParseException;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

/**
 * 
 * @author：songx
 * @date：2018年7月25日,下午5:29:35
 */
@Api(description = "接口健康检查")
public interface InterfaceFacade {

	/**
	 * 健康状态
	 * 
	 * @return
	 * @throws BizException
	 * @throws PermissionException
	 * @throws JsonParseException
	 */
	@ApiOperation(value = "健康状态", httpMethod = "POST")
	@ApiImplicitParams({})
	@RequestMapping(value = "/health", method = RequestMethod.POST)
	ResponseDto<Boolean> health() throws BizException, PermissionException, JsonParseException;

}
