package com.pcloud.common.utils.bean;

import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.utils.ListUtils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;

/**
 * @author：songx
 * @date：2018年8月24日,下午2:18:40
 */
public class BeanUtils extends org.springframework.beans.BeanUtils {

    private static final Logger LOGGER = LoggerFactory.getLogger(BeanUtils.class);

    /**
     * 实体类之间的转换
     *
     * @param source 来源
     * @param clazz  目标对象
     * @return
     */
    public static <T> T copy(Object source, Class<T> clazz) {
        if (source == null) {
            return null;
        }
        T t = null;
        try {
            t = clazz.newInstance();
        } catch (Exception e) {
            LOGGER.error("clazz newInstance is error:" + e.getMessage(), e);
        }
        copyProperties(source, t);
        return t;
    }

    /**
     * 实体类之间的转换
     *
     * @param sources 来源
     * @param clazz   目标对象
     * @return
     */
    public static <T> List<T> copy(List<?> sources, Class<T> clazz) {
        if (ListUtils.isEmpty(sources)) {
            return null;
        }
        List<T> results = new ArrayList<>();
        for (Object source : sources) {
            results.add(copy(source, clazz));
        }
        return results;
    }

    /**
     * 分页结果的实体类之间的转换
     *
     * @param source
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> PageBeanNew<T> copy(PageBeanNew<?> source, Class<T> clazz) {
        if (source == null) {
            return null;
        }
        PageBeanNew<T> result = new PageBeanNew<>();
        copyProperties(source, result);
        List<?> recordList = source.getRecordList();
        if (ListUtils.isEmpty(recordList)) {
            result.setRecordList(new ArrayList<>());
        } else {
            result.setRecordList(copy(recordList, clazz));
        }
        return result;
    }

}
