/**
 * 
 */
package com.pcloud.book.book.dao;

import com.pcloud.book.book.dto.AdviserBookInfoDTO;
import com.pcloud.book.book.dto.AdviserManageDto;
import com.pcloud.book.book.dto.AviserBookInfoParam;
import com.pcloud.book.book.dto.BookAdviserDto;
import com.pcloud.book.book.dto.BookCountAndAdviserIdDTO;
import com.pcloud.book.book.dto.BookCountByAdvisersDto;
import com.pcloud.book.book.dto.BookCountDto;
import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.book.dto.ERPPublishNumDTO;
import com.pcloud.book.book.dto.ErpBookInfoDTO;
import com.pcloud.book.book.entity.BookAdviser;
import com.pcloud.book.book.vo.AgentBookStatsDetailVO;
import com.pcloud.book.book.vo.BookInfo4ScanCount;
import com.pcloud.book.book.vo.BookServesListDTO;
import com.pcloud.book.book.vo.ErpAdviserBookVO;
import com.pcloud.book.es.entity.ESBookAndAdviser;
import com.pcloud.common.core.dao.BaseDao;
import org.apache.ibatis.session.ResultHandler;

import java.util.List;
import java.util.Map;

/**
 * @描述：编辑管理书籍数据访问层接口类
 * @作者：songx
 * @创建时间：2016年12月30日,下午5:15:22 @版本：1.0
 */
public interface BookAdviserDao extends BaseDao<BookAdviser> {


	List<Long> listBookIdsByAdviser(Long adviserId);
	/**
	 * 删除编辑和书籍的推广信息
	 * 
	 * @param bookId
	 *            图书标识
	 * @return
	 */
	public long deleteByBook(Long bookId);

	/**
	 * 批量删除编辑和书籍的推广信息
	 * 
	 * @param bookIds
	 *            图书标识列表
	 * @return
	 */
	public long deleteByBooks(List<Long> bookIds);

	/**
	 * 获取编辑设置的书籍推广信息
	 * 
	 * @param bookAdviser
	 *            图书编辑关联实体
	 * @return
	 */
	public BookAdviserDto getByAdviser(BookAdviser bookAdviser);

	/**
	 * 统计编辑推广的图书总数
	 * 
	 * @param adviserIds
	 *            编辑标识列表
	 * @return
	 */
	public Map<Long, BookAdviserDto> getCountByAdvisers(List<Long> adviserIds);

	/**
	 * 根据ISBN获取图书信息
	 * 
	 * @param paramMap
	 * @return
	 */
	BookAdviserDto getByIsbn(Map<String, Object> paramMap);

	/**
	 * 获取配置过书籍的编辑top1
	 * 
	 * @param paramMap
	 * @return
	 */
	public Long getAdviserTop1(Map<String, Object> paramMap);

//	/**
//	 * 获取该渠道是否配置过该书籍
//	 *
//	 * @param bookAdviser
//	 *            图书编辑关联实体
//	 * @return
//	 */
//	public BookAdviserDto getByChannel(BookAdviser bookAdviser);

	/**
	 * 根据书籍和渠道删除书籍编辑关联信息
	 * 
	 * @param paramMap
	 * @return
	 */
	public Integer deleteByBookAndChannel(Map<String, Object> paramMap);

	/**
	 * 根据图书信息获取主编辑ID
	 * 
	 * @param bookId
	 *            图书标识
	 * @param channelId
	 *            渠道标识
	 * @author: lihao
	 * @date: 2017年7月12日 上午11:00:47
	 */
	public Long getMainAdviserId(Long bookId, Long channelId);

	/**
	 * 根据bookId获取编辑信息
	 * 
	 * @param bookId
	 *            图书标识
	 * @return: List<AdviserManageDto>
	 * @author: lihao
	 * @date: 2017年7月12日 上午11:34:13
	 */
	public List<AdviserManageDto> getAdviserList(Long bookId);

	/**
	 * @Title: getAdviserIdsByBookId
	 * @Description:根据bookId获取编辑ID
	 * @param bookId
	 *            图书标识
	 * @return: List<Long>
	 * @author: lihao
	 * @date: 2017年7月12日 下午5:30:49
	 */
	public List<Long> getAdviserIdsByBookId(Long bookId);

	/**
	 * @Title: delViceAdviser
	 * @Description:编辑管理--删除副编辑
	 * @param bookAdvisers
	 *            图书编辑关联实体列表
	 * @return: void
	 * @author: lihao
	 * @date: 2017年7月12日 下午5:31:03
	 */
	public Integer delViceAdviser(List<BookAdviser> bookAdvisers);

	/**
	 * @Title: getAdviserIdsByBookAndChannel
	 * @Description:获取在某个运营平台关联过某本书的所有编辑的ID（未删除的）
	 * @param bookId
	 *            图书标识
	 * @param channelId
	 *            运营标识
	 * @return: void
	 * @author: lihao
	 * @date: 2017年7月13日 下午5:31:03
	 */
	public List<Long> getAdviserIdsByBookAndChannel(Long bookId, Long channelId);

	/**
	 * @Title: getByBookIds
	 * @Description:根据bookIds查询书刊编辑关联信息
	 * @param bookIds
	 *            图书标识列表
	 * @return: Map<Long,BookAdviserDto>
	 * @author: lihao
	 * @date: 2017年7月17日 上午11:58:35
	 */
	public Map<Long, BookAdviserDto> getByBookIds(List<Long> bookIds);

	/**
	 * 编辑下的所有书刊的数目
	 * 
	 * @param adviserIds
	 *            编辑标识列表
	 * @return
	 */
	public Integer getBookCount(List<Long> adviserIds);

	/**
	 * 更新图书模板
	 * 
	 * @param bookAdviser
	 *            图书编辑关联实体
	 */
	public void updateBookTemplet(BookAdviser bookAdviser);

	/**
	 * 每日新增书刊数-出版
	 * 
	 * @param paramMap
	 * @return
	 */
	public List<BookCountDto> listBookCountByDate4Agent(Map<String, Object> paramMap);

	/**
	 * 删除书籍（编辑端）
	 * 
	 * @param paramMap
	 */
	public void updateBook4Adviser(Map<String, Object> paramMap);

	/**
	 * 该编辑是否是主编辑
	 * 
	 * @param paramMap
	 * @return
	 */
	public Boolean isMainAdviser4Book(Map<String, Long> paramMap);

	/**
	 * 获取编辑设置的书籍推广信息(包含删除或未删除的)
	 * 
	 * @param bookAdviser
	 *            图书编辑关联关系
	 * @return
	 */
	public BookAdviserDto getByAdviserContainsDelete(BookAdviser bookAdviser);

	/**
	 * 获取编辑的图书总数
	 * 
	 * @param adviserId
	 *            编辑标识
	 * @return
	 */
	public Integer getAdviserBookCount(Long adviserId);

	/**
	 * 获取被诉方信息(即与该书关联的所有编辑)
	 * 
	 * @param bookId
	 *            图书标识
	 * @return
	 */
	public List<BookAdviserDto> getAdvisers(Long bookId);

	/**
	 * 获取该书被多少主编辑推广过
	 * @param bookId 图书标识
	 * @return
	 */
	Integer getCount4BookAdviser(Long bookId);

	BookAdviserDto getBase(Long bookId, Long channelId, Long adviserId);
	/**
	 * @Author:lili
	 * @Desr:获取编辑图书基本信息
	 * @Date:2019/2/13 17:35
	 */
    List<AdviserBookInfoDTO> listAdviserBookInfo(AviserBookInfoParam aviserBookInfoParam);

	Map<Long, BookCountAndAdviserIdDTO> getBookCountByAdviserId(BookCountByAdvisersDto bookCountByAdvisersDto);

	/**
	 * 刷数据使用，请勿使用
	 */
	int updateBookBySecondTempletId(Long parentId, Long originTempletId,Long secondTempletId);

	List<ErpAdviserBookVO> listAdviserBook4Erp(Map<String,Object> map);

    /**
     * 设置书刊是否已下印状态
     * @param bookAdviser 图书编辑关联关系
     * @return
     */
    long setIsPrint(BookAdviser bookAdviser);

	List<Long> getBookIdsByTempletId(Long templetId);

	/**
	 * 主编辑其中一本
	 * @param bookId
	 * @return
	 */
	BookAdviserDto getOneMainBook(Long bookId);

	Map<Long, BookAdviserDto> getByBookAdviserIds(List<Long> bookAdviserIds);

    BookAdviserDto getByBookGroupId(Long bookGroupId);

    /**
     * 查书刊数量
     * @author：zhuyajie
     * @date：2020/7/29 10:49
     *  * @param null
     */
    Integer getBookCountByTime(List<Long> adviserIds, String startTime, String endTime);
	/**
	 * 走小睿流程的现代纸书的书刊数量
	 */
	Long getRayBookCount(String startTime, String endTime);

    Integer getIsRui(Long adviserId, Long bookId, Long channelId);

	List<BookAdviserDto> getBookInfoByBookIds(List<Long> bookIds, List<Long> adviserIds, List<Long> channelIds);

    BookAdviserDto getBookByBookIdAdviserId(Long bookId, Long adviserId);

	List<BookAdviserDto> getAdviserBookVarietyStats(List<Long> adviserIds);

    List<ERPPublishNumDTO> getErpPublishNumQueryParams(List<Long> adviserIds);

    List<AgentBookStatsDetailVO> getAgentBookStatsDetail(List<ErpBookInfoDTO> raysBookIds, Integer isRay, String name, List<Long> advisers);

	void updateBookTempletAndLabel(BookAdviser bookAdviser);

	void syncTempletId4ES(ResultHandler<ESBookAndAdviser> resultHandler);

	List<BookInfo4ScanCount> listBookInfo4ScanCount(List<Long> adviserIds, List<Long> channelIds, List<Long> bookIds);

    void updateSendMiniUrlState(Long bookId, Long adviserId, Long channelId, Integer isSendMiniUrl);

	BookDto getBookByBookIdAdviserIdChannelId(Long bookId, Long channelId, Long adviserId1);

	BookDto getLatestAdviserBookByIsbn(String isbn);

	List<BookServesListDTO> listBookServes4Book(Long cursor, Integer limit);

	List<ERPPublishNumDTO> getErpPublishNumQueryParamsByMonth(List<Long> adviserIds, int month);
}
