package com.pcloud.book.group.mapper;

import com.pcloud.book.group.entity.GroupMaterialAccount;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 群二维码永久素材与公众号关系表(GroupMaterialAccount)表数据库访问层
 *
 * @author guiq
 * @since 2020-07-23
 */
@Mapper
@Component
public interface GroupMaterialAccountMapper {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    GroupMaterialAccount queryById(Long id);

    /**
     * 查询指定行数据
     *
     * @param offset 查询起始位置
     * @param limit  查询条数
     * @return 对象列表
     */
    List<GroupMaterialAccount> queryAllByLimit(@Param("offset") int offset, @Param("limit") int limit);


    /**
     * 通过实体作为筛选条件查询
     *
     * @param groupMaterialAccount 实例对象
     * @return 对象列表
     */
    List<GroupMaterialAccount> queryAll(GroupMaterialAccount groupMaterialAccount);

    /**
     * 新增数据
     *
     * @param groupMaterialAccount 实例对象
     * @return 影响行数
     */
    int insert(GroupMaterialAccount groupMaterialAccount);

    /**
     * 修改数据
     *
     * @param groupMaterialAccount 实例对象
     * @return 影响行数
     */
    int update(GroupMaterialAccount groupMaterialAccount);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Long id);

    /**
     * 获取一个新增/更新永久图文素材未达限制的公众号
     *
     * @param useType
     */
    List<GroupMaterialAccount> getActiveAccount(@Param("useType") Integer useType);

    GroupMaterialAccount getByAccountId(@Param("accountId") Long accountId);
}