package com.pcloud.book.push.dao;

import com.pcloud.book.push.entity.Push;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/4/17 17:46
 **/
public interface PushDao extends BaseDao<Push> {
    /**
     * 删除消息推送
     * @param pushId
     * @param partyId
     */
    void deleteByPushId(Long pushId, Long partyId);

    /**
     * 根据id查询
     * @param pushId
     * @return
     */
    Push getByPushId(Long pushId);

    /**
     * 修改群发时间
     * @param push
     */
    void updatePushTime(Push push);

    /**
     * 根据计划id查询
     * @param pushPlanId
     * @return
     */
    List<Push> getByPushPlanId(Long pushPlanId);

    /**
     * 根据群发is集合查询
     * @param pushPlanIds
     * @return
     */
    List<Push> getByPushPlanIds(List<Long> pushPlanIds);

    /**
     * 根据创建人获取计划式群发
     * @param partyId
     * @return
     */
    List<Push> getPlanPushListPartyId(Long partyId);
}
