package com.pcloud.book.rightsSetting.dao.impl;

import com.pcloud.book.rightsSetting.dao.RightsSettingDAO;
import com.pcloud.book.rightsSetting.dto.BookRightsCountsDto;
import com.pcloud.book.rightsSetting.dto.RightsSettingDto;
import com.pcloud.book.rightsSetting.dto.RightsSettingShowStateDTO;
import com.pcloud.book.rightsSetting.entity.RightsSetting;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class RightsSettingDAOImpl   extends BaseDaoImpl<RightsSetting> implements RightsSettingDAO{

    @Override
    public RightsSetting selctByNumber(String number,Integer rightsSettingType) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("rightsNumber",number);
        paramMap.put("rightsSettingType",rightsSettingType);
        return super.getSqlSession().selectOne(getStatement("selctByNumber"),paramMap);
    }

    @Override
    public void updateNumber(Long id, String number) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("id",id);
        paramMap.put("rightsNumber",number);
        super.getSqlSession().update(getStatement("updateNumber"),paramMap);
    }

    @Override
    public int deleteByPrimaryKey(Long id) {
        return super.getSqlSession().delete(getStatement("deleteByPrimaryKey"),id);
    }

    @Override
    public RightsSetting selectByPrimaryKey(Long id) {
        return super.getSqlSession().selectOne(getStatement("selectByPrimaryKey"),id);
    }

    @Override
    public int updateByPrimaryKeySelective(RightsSetting record) {
        return super.getSqlSession().update(getStatement("updateByPrimaryKeySelective"),record);
    }

    @Override
    public int updateByPrimaryKey(RightsSetting record) {
        return  super.getSqlSession().update(getStatement("updateByPrimaryKey"),record);
    }

    @Override
    public RightsSettingDto getByLabel(Long firstClassify, Long secondClassify, Long gradeLabelId, Long subjectLabelId, Long volLabelId, Long verLabelId, Long thirdTempletId) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("firstClassify",firstClassify);
        paramMap.put("secondClassify",secondClassify);
        paramMap.put("thirdClassify",thirdTempletId);
        paramMap.put("gradeLabelId",gradeLabelId);
        paramMap.put("subjectLabelId",subjectLabelId);
        paramMap.put("volLabelId", volLabelId);
        paramMap.put("verLabelId", verLabelId);
        return getSessionTemplate().selectOne(getStatement("getByLabel"),paramMap);
    }

    @Override
    public RightsSettingDto getByBookId(Long bookId) {
        return getSessionTemplate().selectOne(getStatement("getByBookId"), bookId);
    }

    @Override
    public List<RightsSettingDto> listRightsSettingPage(Map<String, Object> map) {
        return getSessionTemplate().selectList(getStatement("listRightsSettingPage"),map);
    }

    @Override
    public List<RightsSettingDto> listByBookId(Long bookId) {
        return getSessionTemplate().selectList(getStatement("listByBookId"), bookId);
    }

    @Override
    public void batchUpdateShowState(RightsSettingShowStateDTO rightsSettingShowStateDTO) {
        getSessionTemplate().update(getStatement("batchUpdateShowState"), rightsSettingShowStateDTO);
    }

    @Override
    public Map<Long, RightsSettingDto> listByBookIds(List<Long> bookIds) {
        return getSessionTemplate().selectMap(getStatement("listByBookIds"), bookIds, "bookId");
    }

    @Override
    public void updateUser(RightsSetting rightsSetting) {
        getSessionTemplate().update(getStatement("updateUser"), rightsSetting);
    }

    @Override
    public RightsSettingDto getDTOById(Long id) {
        return super.getSqlSession().selectOne(getStatement("getDTOById"),id);
    }

    @Override
    public List<BookRightsCountsDto> rightsCountByBookIds(List<Long> bookIds) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookIds",bookIds);
        return getSessionTemplate().selectList(getStatement("rightsCountByBookIds"),paramMap );
    }
}
