package com.pcloud.book.book.biz.impl;

import com.pcloud.book.book.biz.BookTempletFeedbackBiz;
import com.pcloud.book.book.dao.BookTempletFeedbackDao;
import com.pcloud.book.book.entity.BookTempletFeedback;
import com.pcloud.book.book.vo.FeedbackParam;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * @author lily
 * @date 2018/10/31 15:55
 */
@Component("bookTempletFeedbackBiz")
public class BookTempletFeedbackBizImpl implements BookTempletFeedbackBiz {

    @Autowired
    private BookTempletFeedbackDao bookTempletFeedbackDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void create(FeedbackParam feedbackParam, Long adviserId) {
        BookTempletFeedback bookTempletFeedback = new BookTempletFeedback();
        BeanUtils.copyProperties(feedbackParam, bookTempletFeedback);
        bookTempletFeedback.setAdviserId(adviserId);
        bookTempletFeedback.setCreatedUser(adviserId);
        bookTempletFeedbackDao.insert(bookTempletFeedback);
    }
}
