/**
 * 
 */
package com.pcloud.book.consumer.user;

import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.common.utils.string.StringUtil;
import com.pcloud.usercenter.party.adviser.dto.AdviserBaseInfoDto;
import com.pcloud.usercenter.party.adviser.entity.Adviser;
import com.pcloud.usercenter.party.adviser.service.AdviserService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @描述：顾问用户中间类
 * @作者：lili
 * @创建时间：2016年11月17日,上午10:14:01 @版本：1.0
 */
@Component("adviserConsr")
public class AdviserConsr {

	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(AdviserConsr.class);

	@Autowired
	private AdviserService adviserService;

	/**
	 * 获取顾问名称
	 */
	public String getNameById(Long adviserId) throws BizException {
		LOGGER.info("【顾问用户(消)】获取顾问名称,<START>.[adviserId]=" + adviserId);
		String adviserName = "";
		if (adviserId == null) {
			return adviserName;
		}
		try {
			adviserName = ResponseHandleUtil.parseResponse(adviserService.getNameById(adviserId), String.class);
		} catch (Exception e) {
			LOGGER.error("【顾问用户(消)】获取顾问名称.[getNameById]:" + e.getMessage(), e);
		}
		return adviserName == null ? "" : adviserName;
	}

	/**
	 * 批量获取顾问名称
	 */
	public Map<Long, String> getNames(List<Long> adviserIds) throws BizException {
		LOGGER.info("【顾问用户(消)】批量获取顾问名称,<START>.[adviserIds]=" + adviserIds.toString());
		if (ListUtils.isEmpty(adviserIds)) {
			return null;
		}
		Map<Long, String> adviserMap = null;
		try {
			adviserMap = ResponseHandleUtil.parseMapResponse(adviserService.getNames(adviserIds), Long.class,
					String.class);
		} catch (Exception e) {
			LOGGER.error("【顾问用户(消)】批量获取顾问名称.[getNames]:" + e.getMessage(), e);
		}
		return adviserMap;
	}

	/**
	 * 获取顾问基本信息
	 */
	public Adviser getById(Long adviserId) throws BizException {
		LOGGER.info("【顾问用户(消)】获取顾问基本信息,<START>.[adviserId]=" + adviserId);
		if (adviserId == null) {
			return null;
		}
		Adviser adviser = null;
		try {
			adviser = ResponseHandleUtil.parseResponse(adviserService.getById(adviserId), Adviser.class);
		} catch (Exception e) {
			LOGGER.error("【顾问用户(消)】获取顾问基本信息.[getById]:" + e.getMessage(), e);
		}
		return adviser;
	}

	/**
	 * 获取顾问所属出版
	 */
	public Long getAgentIdByAdviser(Long adviserId) throws BizException {
		LOGGER.info("【顾问用户(消)】获取顾问所属出版,<START>.[adviserId]=" + adviserId);
		if (adviserId == null) {
			return null;
		}
		Long agentId = null;
		try {
			agentId = ResponseHandleUtil.parseResponse(adviserService.getAgentIdByAdviser(adviserId), Long.class);
		} catch (Exception e) {
			LOGGER.error("【顾问用户(消)】获取顾问所属出版.[getAgentIdByAdviser]:" + e.getMessage(), e);
		}
		return agentId;
	}

	/**
	 * 获取顾问信息（包含所属出版社）
	 */
	public Map<Long, AdviserBaseInfoDto> getAdviserId2AdviserInfoDtoMap(List<Long> adviserIds) throws BizException {
		LOGGER.info("【顾问用户(消)】获取顾问信息(包含所属出版社),<START>.[adviserIds]=" + adviserIds.toString());
		if (ListUtils.isEmpty(adviserIds)) {
			return null;
		}
		Map<Long, AdviserBaseInfoDto> resultMap = null;
		try {
			resultMap = ResponseHandleUtil.parseMapResponse(adviserService.getAdviserId2AdviserInfoDtoMap(adviserIds),
					Long.class, AdviserBaseInfoDto.class);
		} catch (Exception e) {
			LOGGER.error("【顾问用户(消)】获取顾问信息(包含所属出版社).[getAdviserId2AdviserInfoDtoMap]:" + e.getMessage(), e);
		}
		return resultMap;
	}

	/**
	 * 根据代理标识获取编辑标识列表
	 *
	 * @param agentId
	 * @return
	 */
	public List<Long> getByAgentId(Long agentId) {
		LOGGER.info("【顾问用户(消)】根据代理标识获取编辑标识列表,<START>.[agentId]=" + agentId);
		List<Long> adviserIds = null;
		if (agentId == null) {
			return null;
		}
		try {
			adviserIds = ResponseHandleUtil.parseListResponse(adviserService.getByAgentId(agentId), Long.class);
		} catch (Exception e) {
			LOGGER.error("【顾问用户(消)】根据代理标识获取编辑标识列表.[getByAgentId]:" + e.getMessage(), e);
		}
		return adviserIds;
	}

	/**
	 * 根据名称代理标识获取编辑标识列表
	 *
	 * @param agentId
	 * @return
	 */
	public List<Long> getIdsByNameAndAgentId(Long agentId, String adviserName) {
		LOGGER.info("【顾问用户(消)】根据名称代理标识获取编辑标识列表,<START>.[agentId]=" + agentId + "[adviserName]=" + adviserName);
		List<Long> adviserIds = null;
		if (agentId == null) {
			return null;
		}
		try {
			adviserIds = ResponseHandleUtil
					.parseListResponse(adviserService.getIdsByNameAndAgentId(adviserName, agentId), Long.class);
		} catch (Exception e) {
			LOGGER.error("【顾问用户(消)】根据名称代理标识获取编辑标识列表.[getIdsByNameAndAgentId]:" + e.getMessage(), e);
		}
		return adviserIds;
	}

	/**
	 * 获取默认运营
	 */
	public Long getDefaultChannel(Long adviserId) throws BizException {
		LOGGER.info("【顾问用户(消)】获取默认运营,<START>.[adviserId]=" + adviserId);
		Long channelId = null;
		try {
			channelId =  ResponseHandleUtil.parseResponse(adviserService.getDefaultChannel(adviserId), Long.class);
		} catch (BizException e) {
			throw new BizException(e.getCode(), e.getMessage());
		}catch (Exception e) {
			LOGGER.error("【顾问用户(消)】获取默认运营.[getNameById]:" + e.getMessage(), e);
		}
		return channelId;

	}

	/**
	 * 根据名称获取编辑标识列表
	 * @param adviserName
	 * @return
	 */
	public List<Long> getAdviserIdsByName(String adviserName) {
		LOGGER.info("【顾问用户(消)】根据名称获取编辑标识列表,<START>.[adviserName]=" + adviserName);
		List<Long> adviserIds = new ArrayList<>();
		if (StringUtil.isEmpty(adviserName)) {
			return adviserIds;
		}
		try {
			adviserIds = ResponseHandleUtil
					.parseListResponse(adviserService.getAdviserIdsByName(adviserName), Long.class);
		} catch (Exception e) {
			LOGGER.error("【顾问用户(消)】根据名称获取编辑标识列表.[getAdviserIdsByName]:" + e.getMessage(), e);
		}
		return adviserIds;
	}


}