package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.BookGroupFriendGuideDao;
import com.pcloud.book.group.entity.BookGroupFriendGuide;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 好友引导语
 */
@Component("bookGroupFriendGuideDao")
public class BookGroupFriendGuideDaoImpl extends BaseDaoImpl<BookGroupFriendGuide> implements BookGroupFriendGuideDao {
    @Override
    public void deleteByBookGroupId(Long bookGroupId) {
        getSessionTemplate().delete(getStatement("deleteByBookGroupId"), bookGroupId);
    }

    @Override
    public List<BookGroupFriendGuide> getListByBookGroupId(Long bookGroupId) {
        return getSessionTemplate().selectList(getStatement("getListByBookGroupId"), bookGroupId);
    }
}
