package com.pcloud.book.keywords.dao.impl;

import com.pcloud.book.keywords.dao.SelfRobotKeywordDao;
import com.pcloud.book.keywords.dao.SelfRobotKeywordReplyDao;
import com.pcloud.book.keywords.dto.MaxSeqNAndBGDTO;
import com.pcloud.book.keywords.entity.SelfRobotKeyword;
import com.pcloud.book.keywords.entity.SelfRobotKeywordReply;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author zhuyajie
 * @Date 2020/02/03 11:39
 **/
@Component("selfRobotKeywordReplyDao")
public class SelfRobotKeywordReplyDaoImpl extends BaseDaoImpl<SelfRobotKeywordReply> implements SelfRobotKeywordReplyDao {

    @Override
    public void deleteByKeywordId(Long keywordId) {
        getSessionTemplate().delete(getStatement("deleteByKeywordId"), keywordId);
    }

    @Override
    public List<SelfRobotKeywordReply> getListByKeywordId(Long keywordId) {
        return getSessionTemplate().selectList(getStatement("getListByKeywordId"), keywordId);
    }
}
