package com.pcloud.book.push.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;

import java.util.Date;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @描述：个人号群发记录
 * @作者：zhuyajie
 * @创建时间：16:50 2019/11/27
 * @版本：1.0
 */
public class SelfPushRecordDTO extends BaseDto{

    @ApiModelProperty("群发小号id")
    private String altId;

    @ApiModelProperty("小号名称")
    private String robotName;

    @ApiModelProperty("推送id")
    private Long pushId;

    @ApiModelProperty("推送项id")
    private Long pushItemId;

    @ApiModelProperty("推送内容项类型：1文本,2链接,3应用,4图片")
    private Integer itemType;

    @ApiModelProperty("文本内容")
    private String textContent;

    @ApiModelProperty("链接地址")
    private String linkUrl;

    @ApiModelProperty("链接标题")
    private String linkTitle;

    @ApiModelProperty("链接简介")
    private String linkDescription;

    @ApiModelProperty("链接图片地址")
    private String linkImageUrl;

    @ApiModelProperty("图片链接")
    private String imageUrl;

    @ApiModelProperty("应用id")
    private Long appId;

    @ApiModelProperty("作品id")
    private Long productId;

    @ApiModelProperty("应用链接")
    private String appUrl;

    @ApiModelProperty("作品链接")
    private String productUrl;

    @ApiModelProperty("发送状态（0发送中1发送成功2发送失败）")
    private Integer pushStatus;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("发送好友数量")
    private Integer userCount;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("发送时间")
    private Date sendTime;

    @ApiModelProperty("bookGroupId")
    private Long bookGroupId;

    @ApiModelProperty("bookName")
    private String bookName;

    public String getAltId() {
        return altId;
    }

    public void setAltId(String altId) {
        this.altId = altId;
    }

    public String getRobotName() {
        return robotName;
    }

    public void setRobotName(String robotName) {
        this.robotName = robotName;
    }

    public Long getPushId() {
        return pushId;
    }

    public void setPushId(Long pushId) {
        this.pushId = pushId;
    }

    public Long getPushItemId() {
        return pushItemId;
    }

    public void setPushItemId(Long pushItemId) {
        this.pushItemId = pushItemId;
    }

    public Integer getItemType() {
        return itemType;
    }

    public void setItemType(Integer itemType) {
        this.itemType = itemType;
    }

    public String getTextContent() {
        return textContent;
    }

    public void setTextContent(String textContent) {
        this.textContent = textContent;
    }

    public String getLinkUrl() {
        return linkUrl;
    }

    public void setLinkUrl(String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public String getLinkTitle() {
        return linkTitle;
    }

    public void setLinkTitle(String linkTitle) {
        this.linkTitle = linkTitle;
    }

    public String getLinkDescription() {
        return linkDescription;
    }

    public void setLinkDescription(String linkDescription) {
        this.linkDescription = linkDescription;
    }

    public String getLinkImageUrl() {
        return linkImageUrl;
    }

    public void setLinkImageUrl(String linkImageUrl) {
        this.linkImageUrl = linkImageUrl;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public String getAppUrl() {
        return appUrl;
    }

    public void setAppUrl(String appUrl) {
        this.appUrl = appUrl;
    }

    public String getProductUrl() {
        return productUrl;
    }

    public void setProductUrl(String productUrl) {
        this.productUrl = productUrl;
    }

    public Integer getPushStatus() {
        return pushStatus;
    }

    public void setPushStatus(Integer pushStatus) {
        this.pushStatus = pushStatus;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getUserCount() {
        return userCount;
    }

    public void setUserCount(Integer userCount) {
        this.userCount = userCount;
    }

    public Date getSendTime() {
        return sendTime;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public Long getBookGroupId() {
        return bookGroupId;
    }

    public void setBookGroupId(Long bookGroupId) {
        this.bookGroupId = bookGroupId;
    }

    public String getBookName() {
        return bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName;
    }
}
