package com.pcloud.book.push.facade;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.group.vo.UserBookInfoVO;
import com.pcloud.book.push.biz.SelfPushBiz;
import com.pcloud.book.push.check.PushCheck;
import com.pcloud.book.push.dto.SelfPushAddParamDTO;
import com.pcloud.book.push.dto.SelfPushRecordDTO;
import com.pcloud.common.core.constant.SystemCode;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * @描述：个人号群发
 * @作者：zhuyajie
 * @创建时间：9:46 2019/11/27
 * @版本：1.0
 */
@Api(description = "个人号群发")
@RestController("selfPush")
@RequestMapping("selfPushFacade")
public class SelfPushFacade {
    @Autowired
    private PushCheck pushCheck;
    @Autowired
    private SelfPushBiz selfPushBiz;

    @ApiOperation("创建个人号群发")
    @PostMapping("createSelfPush")
    public ResponseDto<?> createSelfPush(@RequestHeader("token") String token, @RequestBody @ApiParam SelfPushAddParamDTO addParamDTO) throws PermissionException {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long partyId = (Long) map.get(SessionUtil.PARTY_ID);
        String systemCode = (String) map.get(SessionUtil.SYSTEM_CODE);
        addParamDTO.setSystemCode(systemCode);
        pushCheck.selfPushParamCheck(addParamDTO);
        if (partyId == 0){
            String isSystem = (String) map.get(SessionUtil.IS_SYSTEM);
            if ("0".equals(isSystem)) {
                partyId = (Long) map.get(SessionUtil.MEMBER_ID);
            }
        }
        selfPushBiz.createSelfPush(partyId, addParamDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("个人号群发记录用户列表")
    @GetMapping("listSelfPushUser")
    public ResponseDto<PageBeanNew<UserBookInfoVO>> listSelfPushUser(
            @RequestHeader("token") String token, @RequestParam("pushId") @ApiParam("群发id") Long pushId,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage, @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        if (null == pushId) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少群发id");
        }
        if (null == currentPage || null == numPerPage) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少分页参数");
        }
        PageBeanNew<UserBookInfoVO> pageBeanNew = selfPushBiz.listSelfPushUser(pushId, currentPage, numPerPage);
        return new ResponseDto<>(pageBeanNew);
    }

    @ApiOperation("个人号群发记录列表")
    @GetMapping("listSelfPushRecord")
    public ResponseDto<PageBeanNew<SelfPushRecordDTO>> listSelfPushRecord(
            @RequestHeader("token") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage,
            @RequestParam(value = "startTime", required = false) @ApiParam("开始时间") String startTime,
            @RequestParam(value = "endTime", required = false) @ApiParam("结束时间") String endTime,
            @RequestParam(value = "status", required = false) @ApiParam("发送状态（1发送中2发送成功3发送失败）") Integer status) throws PermissionException {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        if (null == currentPage || null == numPerPage) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少分页参数");
        }
        Long partyId = (Long) map.get(SessionUtil.PARTY_ID);
        if (partyId == 0){
            String isSystem = (String) map.get(SessionUtil.IS_SYSTEM);
            if ("0".equals(isSystem)) {
                partyId = (Long) map.get(SessionUtil.MEMBER_ID);
            }
        }
        PageBeanNew<SelfPushRecordDTO> pageBeanNew = selfPushBiz.listSelfPushRecord(currentPage, numPerPage, startTime, endTime, status,partyId);
        return new ResponseDto<>(pageBeanNew);
    }
}
