package com.pcloud.book.book.facade.impl;

import com.pcloud.book.book.biz.BookMinimumSupportBiz;
import com.pcloud.book.book.entity.BookMinimumSupport;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.SessionUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

import io.swagger.annotations.ApiOperation;

/**
 * @ClassName com.pcloud.book.book.facade.impl.BookMinimumSupportFacade
 * @Author zhuyajie
 * @Description 书刊保底支持
 * @Date 2021/1/4 14:34
 * @Version 1.0
 **/
@RestController("bookMinimumSupportFacade")
@RequestMapping("bookMinimumSupport")
public class BookMinimumSupportFacade {

    @Autowired
    private BookMinimumSupportBiz bookMinimumSupportBiz;

    @ApiOperation("创建书刊保底支持")
    @PostMapping("createBookMinimumSupport")
    public ResponseDto<?> createBookMinimumSupport(@RequestHeader("token") String token, @RequestBody BookMinimumSupport bookMinimumSupport) {
        Map<String,Object> map = SessionUtil.getToken4Redis(token);
        Long partyId = (Long) map.get(SessionUtil.PARTY_ID);
        String isSystem = (String) map.get(SessionUtil.IS_SYSTEM);
        if ("0".equals(isSystem)){
            partyId = (Long) map.get(SessionUtil.MEMBER_ID);
        }
        bookMinimumSupport.setCreateUser(partyId);
        bookMinimumSupport.setUpdateUser(partyId);
        bookMinimumSupportBiz.createBookMinimumSupport(bookMinimumSupport);
        return new ResponseDto<>();
    }

    @ApiOperation("修改书刊保底支持")
    @PostMapping("updateBookMinimumSupport")
    public ResponseDto<?> updateBookMinimumSupport(@RequestHeader("token") String token, @RequestBody BookMinimumSupport bookMinimumSupport) {
        Map<String,Object> map = SessionUtil.getToken4Redis(token);
        Long partyId = (Long) map.get(SessionUtil.PARTY_ID);
        String isSystem = (String) map.get(SessionUtil.IS_SYSTEM);
        if ("0".equals(isSystem)){
            partyId = (Long) map.get(SessionUtil.MEMBER_ID);
        }
        bookMinimumSupport.setUpdateUser(partyId);
        bookMinimumSupportBiz.updateBookMinimumSupport(bookMinimumSupport);
        return new ResponseDto<>();
    }

}
