package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.ResourcePageItemDao;
import com.pcloud.book.group.dto.BookServeDTO;
import com.pcloud.book.group.dto.ResourcePageUrlDTO;
import com.pcloud.book.group.dto.BookGroupServeCountDTO;
import com.pcloud.book.group.entity.BookGroupServe;
import com.pcloud.book.group.entity.ResourcePageItem;
import com.pcloud.book.group.vo.ResourcePageItemVO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.group.dao.impl.ResourcePageItemDaoImpl
 * @Author zhuyajie
 * @Description 自有码H5页面资源详情
 * @Date 2021/3/26 15:33
 * @Version 1.0
 **/
@Component
public class ResourcePageItemDaoImpl extends BaseDaoImpl<ResourcePageItem> implements ResourcePageItemDao {

    @Override
    public void deleteByPageColumnId(Long resourcePageColumnId) {
        getSessionTemplate().delete(getStatement("deleteByPageColumnId"), resourcePageColumnId);
    }

    @Override
    public List<ResourcePageItemVO> getResourcePageItemByColumnId(Long resourcePageColumnId) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("resourcePageColumnId", resourcePageColumnId);
        return getSessionTemplate().selectList(getStatement("getResourcePageItemByColumnId"), paramMap);
    }

    @Override
    public List<ResourcePageItemVO> getResourcePageItemByPageId(Long resourcePageId, Boolean isShow) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("resourcePageId", resourcePageId);
        paramMap.put("isShow", isShow);
        return getSessionTemplate().selectList(getStatement("getResourcePageItemByPageId"), paramMap);
    }

    @Override
    public Integer getResourceCounts(Long resourcePageId) {
        return getSessionTemplate().selectOne(getStatement("getResourceCounts"), resourcePageId);
    }

    @Override
    public List<BookGroupServe> getServeListByBookGroupId(Long bookGroupId) {
        return getSessionTemplate().selectList(getStatement("getServeListByBookGroupId"), bookGroupId);
    }

    @Override
    public void deleteByPageId(Long resourcePageId) {
        getSessionTemplate().delete(getStatement("deleteByPageId"), resourcePageId);
    }

    @Override
    public List<BookGroupServe> getServeListByBookGroupIds(List<Long> bookGroupIds) {
        return getSessionTemplate().selectList(getStatement("getServeListByBookGroupIds"), bookGroupIds);
    }

    @Override
    public List<BookGroupServe> getServeListBySceneIds(List<Long> sceneIds) {
        return getSessionTemplate().selectList(getStatement("getServeListBySceneIds"), sceneIds);
    }

    @Override
    public ResourcePageItemVO checkOneServeItemByPageId(Long resourcePageId) {
        return getSessionTemplate().selectOne(getStatement("checkOneServeItemByPageId"), resourcePageId);
    }

    @Override
    public void deleteByServeId(Long resourceId) {
        getSessionTemplate().delete(getStatement("deleteByServeId"), resourceId);
    }

    @Override
    public List<BookServeDTO> getAppServeByPage(Long resourcePageId) {
        return getSessionTemplate().selectList(getStatement("getAppServeByPage"), resourcePageId);
    }

    @Override
    public List<ResourcePageUrlDTO> getServeUrl4Update(List<Long> sceneIdList) {
        return getSessionTemplate().selectList(getStatement("getServeUrl4Update"), sceneIdList);
    }

    @Override
    public void batchUpdateServeUrlById(List<ResourcePageUrlDTO> list) {
        getSessionTemplate().update(getStatement("batchUpdateServeUrlById"), list);
    }

    @Override
    public Map<Long, BookGroupServeCountDTO> mapQrServeCount(List<Long> ruiList) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("sceneIds", ruiList);
        return  getSessionTemplate().selectMap(getStatement("mapQrServeCount"), paramMap, "sceneId");
    }

    @Override
    public List<Long> getHasResourceCode4Erp(List<Long> sceneIds) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("sceneIds", sceneIds);
        return  getSessionTemplate().selectList(getStatement("getHasResourceCode4Erp"), paramMap);
    }

    @Override
    public List<Long> getAppIdsByPageId(Long resourcePageId) {
        return getSessionTemplate().selectList(getStatement("getAppIdsByPageId"), resourcePageId);
    }
}
