package com.pcloud.book.rightsSetting.biz;

import com.pcloud.book.applet.dto.AppletNewsDTO;
import com.pcloud.book.applet.entity.AppletUserBookcase;
import com.pcloud.book.group.dto.BookServeDTO;
import com.pcloud.book.rightsSetting.dto.FillRightsSettingAppletsDTO;
import com.pcloud.book.rightsSetting.dto.PopupResourceInfoDTO;
import com.pcloud.book.rightsSetting.dto.ResourceList4Answer;
import com.pcloud.book.rightsSetting.dto.RightsSettingDto;
import com.pcloud.book.rightsSetting.dto.RightsSettingQueryDTO;
import com.pcloud.book.rightsSetting.dto.RightsSettingShowStateDTO;
import com.pcloud.book.rightsSetting.entity.BaseTempletClassify;
import com.pcloud.book.rightsSetting.entity.RightsItemGroup;
import com.pcloud.book.rightsSetting.entity.RightsNowItem;
import com.pcloud.book.rightsSetting.entity.RightsNowPic;
import com.pcloud.book.rightsSetting.entity.RightsNowPopup;
import com.pcloud.book.rightsSetting.entity.RightsSetting;
import com.pcloud.book.rightsSetting.entity.RightsSettingBanner;
import com.pcloud.book.rightsSetting.entity.RightsSettingClassify;
import com.pcloud.book.rightsSetting.entity.RightsSettingItem;
import com.pcloud.book.rightsSetting.vo.QrcodeMessage4WechatVO;
import com.pcloud.book.applet.dto.GroupActivity4AppletDTO;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;
import java.util.Map;

public interface RightsSettingBiz {
    Long addRightsSetting(RightsSetting rightsSetting);

    void setClassifyAndLabel(BaseTempletClassify baseTempletClassify);

    void deleteRightsSetting(Long id);

    void updateRightsSetting(RightsSetting rightsSetting);

    RightsSetting getRightsSetting(Long id);

    PageBeanNew<RightsSettingDto> listRightsSettingPage(Integer currentPage, Integer numPerPage, RightsSetting rightsSetting);

    RightsSettingDto getByLabel(Long firstClassify, Long secondClassify, Long gradeLabelId, Long subjectLabelId, Long volLabelId, Long verLabelId, Long thirdTempletId);

    Integer getUserCount();

    /**
     * 批量新增每周/长期权益
     * @param rightsSettingItemList
     * @param rightsSettingId
     */
    void batchInsertRightsSettingItem(List<RightsSettingItem> rightsSettingItemList, Long rightsSettingId,String rightsType);

    /**
     * 每周/长期权益查询
     * @param rightsSettingId
     * @param rightsType
     * @param currentPage
     * @param numPerPage
     * @return
     */
    List<RightsSettingItem> getItemsByRightsSettingId(Long rightsSettingId, String rightsType, Integer readType, Integer currentPage, Integer numPerPage);

    /**
     * 小程序首页权益查询
     * @param bookId
     * @param adviserId
     * @param channelId
     * @return
     */
    RightsSettingDto getRightsSettingByBookId4AppletHome(Long bookId, Long adviserId, Long channelId);

    /**
     * 小程序首页权益类型
     * 1：书刊权益；2：分类权益；3：兜底权益；
     */
    Integer getRightsTypeByBookId4AppletHome(Long bookId, Long adviserId, Long channelId);

    /**
     * 小程序首页本周/长期权益查询
     * @param cilentIp
     * @param rightsSettingId
     * @param wechatUserId
     * @param rightsType
     * @param currentPage
     * @param numPerPage
     * @return
     */
    RightsSettingDto getItemByRightsSettingId4AppletHome(Long rightsSettingId, Long wechatUserId, String rightsType, Integer readType, Long bookId, Long adviserId, Long channelId, Integer currentPage, Integer numPerPage,Long officialAccountsId);

    /**
     * 每周/长期权益查询--小程序
     * @param rightsSettingId
     * @param rightsType
     * @param wechatUserId
     * @param cityCode
     * @param currentPage
     * @param numPerPage
     * @return
     */
    List<RightsSettingItem> getItemsByRightsSettingId4Applet(Long rightsSettingId, String rightsType, Long wechatUserId, Integer readType, Long bookId, Long adviserId, Long channelId, String cityCode, Integer currentPage, Integer numPerPage,Long agentId);

    /**
     * 查所有权益分类
     * @param rightsType
     * @return
     */
    List<RightsSettingClassify>getAllRightsClassify(String rightsType);

    /**
     * @Author David
     * @Description 该方法没有补充咨询且会查询所有类型的即可权益，不利于扩展，请使用新方法getRightsSettingRightsNowItemsByType
     * @Date 2020/4/25 11:44
     * @Param [rightsSettingId, wechatUserId]
     * @return com.pcloud.book.rightsSetting.entity.RightsSetting
     **/
    @Deprecated
    RightsSetting getRightsSettingRightsNowItems(Long rightsSettingId, Long wechatUserId);

    /**
     * @Author David
     * @Description 根据权益id和类型获取权益内容
     * @Date 2020/4/25 11:44
     * @Param [rightsSettingId, wechatUserId, type]
     * @return com.pcloud.book.rightsSetting.entity.RightsSetting
     **/
    RightsSetting getRightsSettingRightsNowItemsByType(Long rightsSettingId, Long wechatUserId, Integer type, Long adviserId, Long bookId, Long channelId, Integer readType, Integer currentPage, Integer numPerPage,Long officialAccountsId);

    RightsSetting getRightsSettingGiftCoupons(Long rightsSettingId, Long wechatUserId, Integer readType);

    FillRightsSettingAppletsDTO getFillRightsSettingApplets(Long rightsSettingId, Long wechatUserId, Long rightsClassifyId,
            Integer top, Long bookId, Long officialAccountsId);

    List<RightsItemGroup> getRightsItemGroups(Long rightsSettingId, Long adviserId, Long bookId, Long channelId, Boolean removeCanNotBuy, Integer readType, Long wechatUserId,boolean homePage);

    RightsSettingDto getRightSettingByBookId(Long bookId, Long adviserId, Long channelId);

    List<RightsNowPic> getAllDefaultRightsNowPics(Integer type);

    void addRightsNowPic(RightsNowPic rightsNowPic);

    PageBeanNew<RightsNowPic> getRightsNowPics(Integer currentPage, Integer numPerPage, Integer type, Long agentId);

    void deleteRightsNowPic(Long rightsNowPicId);

    RightsSettingDto getReadType4Book(Long wechatUserId, Long bookId, Long channelId, Long adviserId);

    /**
     * 增加上下册分类权益
     * @author：zhuyajie
     * @date：2020/5/20 19:09
     *  * @param null
     */
    void copyRightsSetting(List<Long> volLabelIds);

    /**
     * 根据书以及阅读方式查询周权益下的咨询
     */
    PageBeanNew<AppletNewsDTO> getWeekRightsSettingNewsByBookId(AppletUserBookcase userReadBook, Integer currentPage, Integer numPerPage);

    /**
     * 书刊权益批量上下架
     *
     * @param rightsSettingShowStateDTO
     */
    void batchUpdateShowState(RightsSettingShowStateDTO rightsSettingShowStateDTO);

    /**
     * 删除无效的资讯
     *
     * @param newArrayList
     */
    void deleteInvalidNews(List<Long> newArrayList);

    Map<Long, RightsSettingDto> listByBookIds(List<Long> bookIds);

    void fillGroupActivityHead(List<GroupActivity4AppletDTO> groupActivity4AppletList);

    void fillThirdGroupHeadList(GroupActivity4AppletDTO groupActivity4AppletDTO);


    /**
     * 要弹出的资源
     * @author：zhuyajie
     * @date：2020/9/15 17:51
     *  * @param null
     */
    PopupResourceInfoDTO getPopupResourceInfoByBook(Long wechatUserId, Long bookId, Long channelId, Long adviserId, Long rightsSettingId, Integer readType);
    /**
     * 资源弹窗记录埋点
     * @author：zhuyajie
     * @date：2020/9/16 10:40
     *  * @param null
     */
    void addPopupRecord(RightsNowPopup rightsNowPopup);

    /**
     * 答案引流资源和权益
     * @author：zhuyajie
     * @date：2020/9/30 14:09
     *  * @param null
     */
    ResourceList4Answer getResourceListByBook4Answer(Long wechatUserId, Long bookId, Long channelId, Long adviserId, Long sceneId);

    /**
     * 填充应用作品
     * @param nowItems
     */
    void fillProductAndApp(List<RightsNowItem> nowItems);

    AppletNewsDTO getAppletNewsDTO4UserReadBook(AppletUserBookcase userReadBook);

    QrcodeMessage4WechatVO getRightsItemGroupsByBookGroup(Long bookGroupId, Long wechatUserId);

    /**
     * 查弹窗弹出次数
     * @author：zhuyajie
     * @date：2020/11/20 16:58
     *  * @param null
     */
    Integer getPopupCount(Long wechatUserId, Long bookId, Integer popupType);

    /**
     * 更新权益配置
     * @author：zhuyajie
     * @date：2020/12/24 15:54
     *  * @param null
     */
    void updateRightsSettingNew(RightsSetting rightsSetting);

    /**
     * 权益查询
     * @author：zhuyajie
     * @date：2020/12/24 16:49
     *  * @param null
     */
    RightsSetting getRightsSettingNew(Long id);

    /**
     * 小程序查资源服务
     * @author：zhuyajie
     * @date：2020/12/24 17:43
     *  * @param null
     */
    RightsSetting getRightsSettingItemsByTypeListNew(RightsSettingQueryDTO rightsSettingQueryDTO);

    /**
     * 所有权益分类-新版
     * @author：zhuyajie
     * @date：2020/12/25 14:15
     *  * @param null
     */
    List<RightsSettingClassify> getAllRightsClassifyNew();

    /**
     * 书刊相应权益配置的应用和作品
     * @author：zhuyajie
     * @date：2021/2/19 17:42
     *  * @param null
     */
        List<BookServeDTO> getRightsSettingAppProduct(Long bookId, Long channelId, Long adviserId, Integer limit);

    /**
     * 填充权益banner
     * @param rightsSettingBanners
     */
    void fillReadGuide(List<RightsSettingBanner> rightsSettingBanners);

    /**
     * 根据图书信息及权益ID检查是否配置了读书卡片应用
     */
    Map<String,Object> getBookCardId4Book(Long bookId, Long channelId, Long adviserId, Long rightsSettingId);

    /**
     * 处理资讯
     */
    void handleNews();
}
