package com.pcloud.book.applet.entity;

import java.util.Date;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * (AppletGroupSearchRecord)实体类
 *
 * @author zyq
 * @since 2020-04-01 17:34:47
 */
@Data
public class AppletGroupSearchRecord extends BaseEntity {

    private static final long serialVersionUID = 217602641427761867L;
    
    private Long id;
    
    @ApiModelProperty("社群码id")
    private Long bookGroupId;
    
    @ApiModelProperty("用户id")
    private Long wechatUserId;
    
    @ApiModelProperty("图书id")
    private Long bookId;
    
    @ApiModelProperty("运营id")
    private Long channelId;
    
    @ApiModelProperty("编辑id")
    private Long adviserId;
    
    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("更新时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
    
}