package com.pcloud.book.cultivate.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


@Data
@ApiModel("小睿站内信")
public class CultivateNotify extends BaseEntity {

    @ApiModelProperty("消息id")
    private Long messageId;

    @ApiModelProperty("消息类型（1-系统消息，2-通知消息，3-提醒消息，4-活动消息）")
    private Integer messageType;

    @ApiModelProperty("消息标题")
    private String title;

    @ApiModelProperty("发送类型（1-指定用户，2-分类用户，3-按书籍查询，4-全局公告消息）")
    private Integer sendType;

    @ApiModelProperty("出版社id")
    private Long agentId;

    @ApiModelProperty("是否首页弹窗")
    private Integer showHome;

    @ApiModelProperty("首页推图")
    private String squareImg;
}
