package com.pcloud.book.group.constant;

import com.pcloud.book.applet.contants.AppletResourceApplyConstants;
import com.pcloud.common.constant.CacheConstant;

import java.util.Arrays;
import java.util.List;

/**
 * @ClassName com.pcloud.book.group.constant.ResourcePageConstants
 * @Author zhuyajie
 * @Description 资源页
 * @Date 2021/4/2 14:44
 * @Version 1.0
 **/
public class ResourcePageConstants {

    /**
     * 栏目类型
     * @author：zhuyajie
     * @date：2021/3/31 15:13
     *  * @param null
     */
    public enum ColumnTypeEnum {

        APP_PRODUCT(1, "应用作品", new String[]{ServeTypeEnum.APP.getValue(), ServeTypeEnum.PRODUCT.getValue()}),
        OFFICIAL_ACCOUNT(2, "公众号", new String[]{ServeTypeEnum.OFFICIAL_ACCOUNT.getValue()}),
        BOOKLIST(3, "书单", new String[]{ServeTypeEnum.BOOKLIST.getValue(),ServeTypeEnum.ADVISER_BOOK.getValue()}),
        GROUP(4, "社群", new String[]{ServeTypeEnum.GROUP_ACTIVITY.getValue(), ServeTypeEnum.WXWORK_GROUP.getValue()}),
        THIRD_RESOURCE(5, "第三方资源", new String[]{ServeTypeEnum.THIRD_RESOURCE.getValue()}),
        PICTURE(6, "图片位", new String[]{ServeTypeEnum.APP.getValue(), ServeTypeEnum.PRODUCT.getValue(),
                ServeTypeEnum.GROUP_ACTIVITY.getValue(), ServeTypeEnum.THIRD_RESOURCE.getValue(), ServeTypeEnum.NO_SERVE.value}),
        RAYS_TOOL(7,"RAYS工具",new String[]{ServeTypeEnum.APP.getValue()}),
        MEMBER_ACTIVITY(8,"平台会员活动", new String[]{ServeTypeEnum.MEMBER_ACTIVITY.getValue()});

        private Integer code;
        private String name;
        private String[] serves;

        public String[] getServes() {
            return serves;
        }

        public void setServes(String[] serves) {
            this.serves = serves;
        }

        public Integer getCode() {
            return code;
        }
        public void setCode(Integer code) {
            this.code = code;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        ColumnTypeEnum(Integer code, String name, String[] serves) {
            this.code = code;
            this.name = name;
            this.serves = serves;
        }
    }


    /**
     * @Author zhuyajie
     * @Description 资源页资源类型
     * @Date 2021/3/29 16:25
     * @Version 1.0
     **/
    public enum ServeTypeEnum {

        APP("APP", "应用"),
        PRODUCT("PRODUCT", "作品"),
        OFFICIAL_ACCOUNT("OFFICIAL_ACCOUNT", "公众号"),
        BOOKLIST("BOOKLIST", "平台书单"),
        ADVISER_BOOK("ADVISER_BOOK", "书刊"),
        GROUP_ACTIVITY("GROUP_ACTIVITY", "模板群"),
        THIRD_RESOURCE("THIRD_RESOURCE", "第三方资源"),
        WXWORK_GROUP("WXWORK_GROUP","企业微信群"),
        MEMBER_ACTIVITY("MEMBER_ACTIVITY","平台会员活动"),
        NO_SERVE("NO_SERVE","无服务");

        private String value;

        private String name;

        public String getValue() {
            return value;
        }

        public String getName() {
            return name;
        }

        ServeTypeEnum(String value, String name) {
            this.value = value;
            this.name = name;
        }

        public static String getNameByValue(String value) {
            for (ServeTypeEnum serveTypeEnum : ServeTypeEnum.values()) {
                if (value.equals(serveTypeEnum.value)) {
                    return serveTypeEnum.name;
                }
            }
            return null;
        }
    }

    /**
     * 栏目移动枚举
     */
    public enum MoveTypeEnum{

        /**
         * 向上移
         */
        MOVE_UP("UP"),
        MOVE_DOWN("DOWN");

        private String value;

        MoveTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }
    }

    public enum QrcodeSourceEnum {
        OFFICIAL_ACCOUNT(0, "公众号二维码"),
        CUSTOM(1, "自定义");

        public final Integer value;
        public final String desc;

        QrcodeSourceEnum(Integer value, String desc){
            this.value = value;
            this.desc = desc;
        }
    }

    /**
     * H5工具类型
     * @author：zhuyajie
     * @date：2021/5/12 16:35
     *  * @param null
     */
    public enum ToolTypeEnum{

        HELP(1, "互助"),
        CLOCK(2, "打卡"),
        ANSWER(3, "搜答案"),
        RESOURCE(4, "资源广场"),
        WORD(5, "背单词"),
        PRETEST(6, "题库"),
        SUBJECTNOTE(7, "错题本"),
        TEACHER(8, "1v1老师"),
        COURSE(9, "课程"),
        BOOKLIST(10, "书单");

        private Integer code;
        private String name;

        public Integer getCode() {
            return code;
        }

        public String getName() {
            return name;
        }

        ToolTypeEnum(Integer code, String name) {
            this.code = code;
            this.name = name;
        }
    }

    /**
     * 资源广场学龄段对应模块
     * @author：zhuyajie
     * @date：2021/5/13 11:22
     *  * @param null
     */
    public enum CrowdSourceEnum {
        /**
         * 学龄前：育儿宝库：
         */
        PRESCHOOL(new Integer[]{AppletResourceApplyConstants.CrowdTypeEnum.PRESCHOOL.getCode()},
                new ResourceSourceTypeEnum[]{ResourceSourceTypeEnum.CHILD}),
        /**
         * 小学、初中、高中、大学：搜教辅资料：(答案、试卷、课件/教案、作文、知识点汇总)
         */
        SCHOOL(new Integer[]{
                AppletResourceApplyConstants.CrowdTypeEnum.PRIMARY_SCHOOL.getCode(),
                AppletResourceApplyConstants.CrowdTypeEnum.JUNIOR_HIGH_SCHOOL.getCode(),
                AppletResourceApplyConstants.CrowdTypeEnum.SENIOR_HIGH_SCHOOL.getCode(),
                AppletResourceApplyConstants.CrowdTypeEnum.UNIVERSITY.getCode()},
                new ResourceSourceTypeEnum[]{
                        ResourceSourceTypeEnum.PAPER,
                        ResourceSourceTypeEnum.PDF,
                        ResourceSourceTypeEnum.ARTICLE,
                        ResourceSourceTypeEnum.KNOWLEDGE});
        private Integer[] crowdTypes;
        private ResourceSourceTypeEnum[] sourceTypes;

        public Integer[] getCrowdTypes() {
            return crowdTypes;
        }

        public ResourceSourceTypeEnum[] getSourceTypes() {
            return sourceTypes;
        }

        CrowdSourceEnum(Integer[] crowdTypes, ResourceSourceTypeEnum[] sourceTypes) {
            this.crowdTypes = crowdTypes;
            this.sourceTypes = sourceTypes;
        }
    }

    /**
     * 资源广场模块
     * @author：zhuyajie
     * @date：2021/5/13 11:46
     *  * @param null
     */
    public enum ResourceSourceTypeEnum{
        CHILD(1,"育儿宝库", new String[]{"手抄报","涂色","手工","亲子","游戏","简笔画","启蒙","早教"},
                new Integer[]{AppletResourceApplyConstants.CrowdTypeEnum.PRESCHOOL.getCode()}),
        PAPER(5,"试卷", new String[]{"试卷"},
                new Integer[]{AppletResourceApplyConstants.CrowdTypeEnum.PRIMARY_SCHOOL.getCode(),
                        AppletResourceApplyConstants.CrowdTypeEnum.JUNIOR_HIGH_SCHOOL.getCode(),
                        AppletResourceApplyConstants.CrowdTypeEnum.SENIOR_HIGH_SCHOOL.getCode(),
                        AppletResourceApplyConstants.CrowdTypeEnum.UNIVERSITY.getCode()}),
        PDF(6,"课件/教案",new String[]{"课件","教案"},
                new Integer[]{AppletResourceApplyConstants.CrowdTypeEnum.PRIMARY_SCHOOL.getCode(),
                        AppletResourceApplyConstants.CrowdTypeEnum.JUNIOR_HIGH_SCHOOL.getCode(),
                        AppletResourceApplyConstants.CrowdTypeEnum.SENIOR_HIGH_SCHOOL.getCode(),
                        AppletResourceApplyConstants.CrowdTypeEnum.UNIVERSITY.getCode()}),
        ARTICLE(7,"作文",new String[]{"作文"},
                new Integer[]{AppletResourceApplyConstants.CrowdTypeEnum.PRIMARY_SCHOOL.getCode(),
                        AppletResourceApplyConstants.CrowdTypeEnum.JUNIOR_HIGH_SCHOOL.getCode(),
                        AppletResourceApplyConstants.CrowdTypeEnum.SENIOR_HIGH_SCHOOL.getCode(),
                        AppletResourceApplyConstants.CrowdTypeEnum.UNIVERSITY.getCode()}),
        KNOWLEDGE(8,"知识点汇总", new String[]{"知识点汇总"},
                new Integer[]{AppletResourceApplyConstants.CrowdTypeEnum.PRIMARY_SCHOOL.getCode(),
                        AppletResourceApplyConstants.CrowdTypeEnum.JUNIOR_HIGH_SCHOOL.getCode(),
                        AppletResourceApplyConstants.CrowdTypeEnum.SENIOR_HIGH_SCHOOL.getCode(),
                        AppletResourceApplyConstants.CrowdTypeEnum.UNIVERSITY.getCode()});
        private Integer code;
        private String name;
        private String[] keywords;
        private Integer[] crowdTypes;

        public Integer getCode() {
            return code;
        }

        public String getName() {
            return name;
        }

        public String[] getKeywords() {
            return keywords;
        }

        public Integer[] getCrowdTypes() {
            return crowdTypes;
        }

        ResourceSourceTypeEnum(Integer code, String name, String[] keywords, Integer[] crowdTypes) {
            this.code = code;
            this.name = name;
            this.keywords = keywords;
            this.crowdTypes = crowdTypes;
        }
    }

    /**
     * 资源推荐管理-类型
     * @author：zhuyajie
     * @date：2021/7/9 15:02
     *  * @param null
     */
    public enum RecommendResourceFromEnum{
        //（1育儿宝库2教辅资料3热门课程）
        CHILD_RESOURCE(1, new Integer[]{ResourceSourceTypeEnum.CHILD.getCode()}),
        TEACHE_RESOURCE(2, new Integer[]{
                ResourceSourceTypeEnum.PAPER.getCode(),ResourceSourceTypeEnum.PDF.getCode(),
                ResourceSourceTypeEnum.ARTICLE.getCode(), ResourceSourceTypeEnum.KNOWLEDGE.getCode()
        }),
        HOT_COURSE(3,new Integer[]{});
        private Integer code;
        private Integer[] sourceTypes;

        public Integer getCode() {
            return code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public Integer[] getSourceTypes() {
            return sourceTypes;
        }

        public void setSourceTypes(Integer[] sourceTypes) {
            this.sourceTypes = sourceTypes;
        }

        RecommendResourceFromEnum(Integer code, Integer[] sourceTypes) {
            this.code = code;
            this.sourceTypes = sourceTypes;
        }

        public static List<Integer> getSourceTypesByCode(Integer code) {
            for (RecommendResourceFromEnum resourceFromEnum:RecommendResourceFromEnum.values()){
                if (resourceFromEnum.getCode().equals(code)){
                    return Arrays.asList(resourceFromEnum.getSourceTypes());
                }
            }
            return null;
        }
    }

    /**
     * 导航类型
     * @author：zhuyajie
     * @date：2021/8/16 11:59
     *  * @param null
     */
    public enum NavigationTypeEnum{
        BOOK_SERVE(1,"本书配套"),
        APPLET_QA(2,"书友互助"),
        CUSTOM(3,"自定义"),
        CLOCK(4,"阅读打卡");
        private Integer code;
        private String name;

        public Integer getCode() {
            return code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        NavigationTypeEnum(Integer code, String name) {
            this.code = code;
            this.name = name;
        }

        public static String getNameByCode(Integer code) {
            for (NavigationTypeEnum navigationTypeEnum:NavigationTypeEnum.values()){
                if (navigationTypeEnum.code.equals(code)){
                    return navigationTypeEnum.name;
                }
            }
            return null;
        }
    }

    //小程序默认导航，书友互助、阅读打卡
    public static List<Integer> APPLET_DEFAULT_NAVIGATIONS = Arrays.asList(ResourcePageConstants.NavigationTypeEnum.APPLET_QA.getCode(),
            ResourcePageConstants.NavigationTypeEnum.CLOCK.getCode());
    /**
     * H5-公众号二维码展示方式
     * @author：zhuyajie
     * @date：2021/8/23 15:14
     *  * @param null
     */
    public enum QrcodeShowTypeEnum{
        //1平铺2弹窗
        TILED(1),
        POPUP(2);
        private Integer code;

        public Integer getCode() {
            return code;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        QrcodeShowTypeEnum(Integer code) {
            this.code = code;
        }
    }

}
