package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.ResourcePageCourseDao;
import com.pcloud.book.group.entity.ResourcePageCourse;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

/**
 * @ClassName com.pcloud.book.group.dao.impl.ResourcePageCourseDaoImpl
 * @Author zhuyajie
 * @Description 资源统计
 * @Date 2021/5/17 14:52
 * @Version 1.0
 **/
@Component
public class ResourcePageCourseDaoImpl extends BaseDaoImpl<ResourcePageCourse> implements ResourcePageCourseDao{
    @Override
    public void deleteAll() {
        getSessionTemplate().delete(getStatement("deleteAll"));
    }

    @Override
    public Long getGradeByGradeLabelId(Long graLabelId) {
        return getSessionTemplate().selectOne(getStatement("getGradeByGradeLabelId"), graLabelId);
    }

    @Override
    public Long getGradeByDepLabelId(Long depLabelId) {
        return getSessionTemplate().selectOne(getStatement("getGradeByDepLabelId"), depLabelId);
    }
}
