package com.pcloud.book.group.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 实体书购买(ResourcePageBookstore)实体类
 *
 * @author makejava
 * @since 2021-08-16 14:40:27
 */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ResourcePageBookstoreVO {

    @ApiModelProperty("实体书购买id")
    private Long id;
    
    @ApiModelProperty("资源页id")
    private Long resourcePageId;
    
    @ApiModelProperty("服务id")
    private Long serveId;

    @ApiModelProperty("相对链接")
    private String linkUrl;

    @ApiModelProperty("跳转结果页链接")
    private String resultUrl;
    
    @ApiModelProperty("服务类型；APP/PRODUCT")
    private String serveType;

    @ApiModelProperty("服务名称")
    private String serveName;

    @ApiModelProperty("图片")
    private String servePic;

    @ApiModelProperty("服务类型")
    private String serveTypeCode;

    @ApiModelProperty("服务类型名称")
    private String serveTypeName;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

}
