package com.pcloud.book.push.dao.impl;

import com.pcloud.book.push.dao.PushGroupRecordDao;
import com.pcloud.book.push.entity.PushGroupRecord;
import com.pcloud.book.push.enums.PushStatusEnum;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/4/17 17:36
 **/
@Repository("pushGroupRecordDao")
public class PushGroupRecordDaoImpl extends BaseDaoImpl<PushGroupRecord> implements PushGroupRecordDao {
    @Override
    public Integer batchInsert(List<PushGroupRecord> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    @Override
    public void updateStateById(Integer pushGroupRecordId, Integer pushStatus) {
        Map<String, Object> map = new HashMap<>();
        map.put("pushGroupRecordId", pushGroupRecordId);
        map.put("pushStatus", pushStatus);
        super.getSqlSession().update(getStatement("updateStateById"), map);
    }

    @Override
    public List<PushGroupRecord> getListByPushRecordId(Long pushRecordId) {
        return super.getSqlSession().selectList(getStatement("getListByPushRecordId"), pushRecordId);
    }

    @Override
    public void updateStateByPushRecordId(Long pushRecordId, Integer pushStatus) {
        Map<String, Object> map = new HashMap<>();
        map.put("pushRecordId", pushRecordId);
        map.put("pushStatus", pushStatus);
        super.getSqlSession().update(getStatement("updateStateByPushRecordId"), map);
    }
}
