package com.pcloud.book.advertising.dto;

import com.pcloud.common.dto.BaseDto;

import java.util.List;

import lombok.Data;

/**
 * @描述：二维码及资源数据查询参数
 * @作者：zhuyajie
 * @创建时间：16:02 2020/4/16
 * @版本：1.0
 */
@Data
public class BrandDataDTO4Channel extends BaseDto{
    /**
     * 来源类型（BOOK/QRCODE/APP/PRODUCT）
     */
    private String fromType;
    /**
     * 书刊id
     */
    private Long bookId;
    /**
     * 编辑id
     */
    private Long adviserId;
    /**
     * 运营id
     */
    private Long channelId;
    /**
     * 二维码id
     */
    private Long sceneId;

    /**
     * 二维码列表
     */
    private List<Long> sceneIdList;
    /**
     * 应用或作品id
     */
    private List<Long>serveIdList;

    /**
     * 扫码人数
     */
    private Integer scanQrUserCount;

    /**
     * 读者量
     */
    private Integer readerNum;
    /**
     * 浏览量
     */
    private Integer browseNum;
}
