package com.pcloud.book.group.dto;

import com.pcloud.common.dto.BaseDto;

import lombok.Data;

/**
 * @ClassName com.pcloud.book.group.dto.ResourcePageDTO
 * @Author zhuyajie
 * @Description 资源页信息
 * @Date 2021/8/30 11:04
 * @Version 1.0
 **/
@Data
public class ResourcePageDTO extends BaseDto {
    /**
     * rays码id
     */
    private Long bookGroupId;
    /**
     * 风格类型（1默认2艺术3插画）
     */
    private Integer style;
    /**
     * 是否显示图书信息
     */
    private Integer showBook;
    /**
     * 是否开启小睿流程
     */
    private Integer openRays;
    /**
     * 是否开启世间食记
     */
    private Integer openFood;
    /**
     * 创建人
     */
    private Long createUser;
    /**
     * 预览二维码
     */
    private String qrcodeUrl;
    /**
     * 二维码id
     */
    private Long sceneId;
    /**
     * 公众号二维码id
     */
    private Long officialSceneId;
    /**
     * 自定义配置的图书封面
     */
    private String bookCover;

    /**
     * 书刊id
     */
    private Long bookId;
    /**
     * 渠道id
     */
    private Long channelId;
    /**
     * 背景图
     */
    private String backgroundImg;
    /**
     * 二维码图片解析后的地址
     */
    private String url;
}
