package com.pcloud.book.group.enums;

/**
 * 自建码跳转类型
 * @author：zhuyajie
 * @date：2020/12/1 15:29
 *  * @param null
 */
public enum QrcodeJumpType {

    /**
     * 进小程序-书僮小睿 /t-3/
     */
    APPLET_XIAORUI(1, "书僮小睿"),

    /**
     * 进小程序-书晓 /t-4/
     */
    APPLET_SHUXIAO(2, "书晓"),

    /**
     * 进h5-书僮小睿小程序码/跳转按钮 /t-5/
     */
    H5_XIAORUI(3, "书僮小睿小程序码/跳转按钮"),

    /**
     * 进h5-企业微信活码
     */
    H5_ENTERPRISE_WECHAT(4,"企业微信活码"),
    /**
     * 进h5-出版社公众号二维码 /t-6/
     */
    H5_OFFICIAL_ACCOUNTS(5,"出版社公众号二维码"),
    /**
     * 进h5-自定义链接
     */
    H5_SELF_URL(6,"自定义链接"),
    /**
     * 进h5-资源页 /t-7/
     */
    H5_RESOURCE(7,"资源页");

    private final Integer code;

    private final String name;

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    private QrcodeJumpType(Integer code, String name) {
        this.code = code;
        this.name = name;
    }
    public static final Integer[] XIAORUI_JUMP_TYPES = {APPLET_XIAORUI.code, H5_XIAORUI.code};
}
