package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.dto.AppletRecordStatisDTO;
import com.pcloud.book.applet.dto.ReadBookWeekStatisDTO;
import com.pcloud.book.applet.entity.AppletRecordStatis;
import com.pcloud.common.page.PageBeanNew;

import java.util.Date;
import java.util.List;

/**
 * 小睿小程序点击量统计(AppletRecordStatis)表服务接口
 *
 * @author makejava
 * @since 2020-12-10 17:58:06
 */
public interface AppletRecordStatisBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    AppletRecordStatis getById(Long id);

    /**
     * 分页查询
     */
    PageBeanNew getList(Integer currentPage, Integer numPerPage);

    /**
     * 新增数据
     *
     * @param appletRecordStatis 实例对象
     * @return 主键
     */
    Long insert(AppletRecordStatis appletRecordStatis);

    /**
     * 修改数据
     *
     * @param appletRecordStatis 实例对象
     */
    void update(AppletRecordStatis appletRecordStatis);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Long id);

    ReadBookWeekStatisDTO getReadBookWeekStatis(Long wechatUserId, String mondayDate);

    /**
     * 本周读书相关信息（阅读本数等）
     */
    ReadBookWeekStatisDTO getReadBookWeekStatisDTO(Long wechatUserId, Date monday, Date sunday);

    List<AppletRecordStatisDTO> getBookSourceWeekStatis(Long wechatUserId, String mondayDate);

    List<AppletRecordStatisDTO> getBookNewsWeekStatis(Long wechatUserId, String mondayDate);

    /**
     * 删除指定日期的统计数据
     */
    void deleteWeekAppletRecordStatis(String mondayDate);
    /**
     * 添加应用作品周统计数据
     */
    void addWeekAppletRecordStatis(String mondayDate);

}
