package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.dto.AppletThirdResourcesDTO;
import com.pcloud.book.applet.dto.ThirdResourceRecordDTO;
import com.pcloud.book.applet.entity.AppletThirdResources;
import com.pcloud.book.applet.entity.AppletThirdResourcesClick;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;
import java.util.Map;

public interface AppletThirdResourcesBiz {

    AppletThirdResourcesDTO getAnalysisDetail(Long thirdResourcesId);

    PageBeanNew<AppletThirdResourcesDTO> getListThirdResourcesAnalysis(String keyValue, String source,
            String resourcesType, Integer browseQty, Integer clickQty, Integer currentPage, Integer numPerPage);

    void addServiceRecord(AppletThirdResourcesClick thirdResourcesClick);

    AppletThirdResourcesDTO getNewsTrendChart(Long newsId);

    PageBeanNew<AppletThirdResources> getThirdResources(Long type, String source, String keyValue, Integer currentPage,
            Integer numPerPage);

    void deleteAppletsById(Long id);

    void updateThirdResources(AppletThirdResourcesDTO thirdResourcesDTO);

    AppletThirdResources getAppletsById(Long id);

    List<AppletThirdResources> getAppletsByIds(List<Long> ids);

    void createThirdResources(AppletThirdResourcesDTO thirdResourcesDTO);

    PageBeanNew<ThirdResourceRecordDTO> listThirdResourceRecord(String queryName, Integer currentPage, Integer numPerPage, String wechatUser, Long thirdResourceId, Integer recordType);

    Map<Long, AppletThirdResources> getAppletMapByIds(List<Long> list);

    List<AppletThirdResources> getThirdResourcesByNewsId(Long newsId);

    /**
     * H5资源页-我的-为你推荐
     * @author：zhuyajie
     * @date：2021/5/11 11:02
     *  * @param null
     */
    PageBeanNew<AppletThirdResources> getThirdResourcesByGradeLabel4ResourcePage(Long gradeLabelId, Integer currentPage,
                                                                                 Integer numPerPage);
}
