package com.pcloud.book.applet.dao;


import com.pcloud.book.applet.entity.AppletResourceApply;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * 第三方资源/书单/banner适用范围(AppletResourceApply)表数据库访问层
 *
 * @author makejava
 * @since 2021-05-08 14:11:42
 */
public interface AppletResourceApplyDao extends BaseDao<AppletResourceApply>{


    /**
     * 删除适用人群
     * @author：zhuyajie
     * @date：2021/5/8 15:27
     *  * @param null
     */
    void deleteCrowdType(Long targetId, String targetType);

    /**
     * 删除内容类型
     * @author：zhuyajie
     * @date：2021/5/8 15:27
     *  * @param null
     */
    void deleteContentType(Long targetId, String targetType);

    /**
     * 查适用人群
     * @author：zhuyajie
     * @date：2021/5/8 15:48
     *  * @param null
     */
    List<Integer> getCrowdTypeList(Long targetId, String targetType);

    /**
     * 查内容类型
     * @author：zhuyajie
     * @date：2021/5/8 15:48
     *  * @param null
     */
    List<Integer> getContentTypeList(Long targetId, String targetType);
}