package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.biz.AppletSubscribeCountBiz;
import com.pcloud.book.applet.entity.AppletSubscribeCount;
import com.pcloud.book.applet.entity.AppletSubscribeRecord;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.cookie.Cookie;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * (AppletSubscribeCount)表控制层
 *
 * @author wubo
 * @since 2021-08-03 09:37:46
 */
@RestController("appletSubscribeCountFacade")
@RequestMapping("appletSubscribeCount")
public class AppletSubscribeCountFacade {

    @Autowired
    private AppletSubscribeCountBiz appletSubscribeCountBiz;


    @ApiOperation("通过主键查询单条数据")
    @GetMapping("getById")
    public ResponseDto<?> getById(@CookieValue("userInfo") String userInfo,
                                  @RequestParam Long id) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletSubscribeCountBiz.getById(id));
    }

    @ApiOperation("分页查询")
    @GetMapping("getList")
    public ResponseDto<?> getList(@CookieValue("userInfo") String userInfo,
                                  @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                  @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletSubscribeCountBiz.getList(currentPage, numPerPage));
    }

    @ApiOperation("新增")
    @PostMapping("insert")
    public ResponseDto<?> insert(@CookieValue("userInfo") String userInfo,
                                 @RequestBody AppletSubscribeCount appletSubscribeCount)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletSubscribeCountBiz.insert(appletSubscribeCount));
    }

    @ApiOperation("更新")
    @PostMapping("update")
    public ResponseDto<?> update(@CookieValue("userInfo") String userInfo,
                                 @RequestBody AppletSubscribeCount appletSubscribeCount) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        appletSubscribeCountBiz.update(appletSubscribeCount);
        return new ResponseDto<>();
    }

    @ApiOperation("删除")
    @GetMapping("deleteById")
    public ResponseDto<?> deleteById(@CookieValue("userInfo") String userInfo,
                                     @RequestParam Long id) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if (null == id) {
            throw BizException.PARAM_DELETION;
        }
        appletSubscribeCountBiz.deleteById(id);
        return new ResponseDto<>();
    }

    @ApiOperation("软删除")
    @GetMapping("softDeleteById")
    public ResponseDto<?> softDeleteById(@CookieValue("userInfo") String userInfo,
                                         @RequestParam Long id) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if (null == id) {
            throw BizException.PARAM_DELETION;
        }
        appletSubscribeCountBiz.softDeleteById(id);
        return new ResponseDto<>();
    }

    @ApiOperation("通过用户id查询单条数据")
    @GetMapping("getByUserId")
    public ResponseDto<?> getByUserId(@CookieValue("userInfo") String userInfo,
                                      @RequestParam(value = "recordType", required = false) Integer recordType) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        AppletSubscribeCount byUserId = appletSubscribeCountBiz.getByUserId(wechatUserId, recordType);
        return new ResponseDto<>(null == byUserId ? 0L : byUserId.getValidCount());
    }

    @ApiOperation("清零用户次数")
    @GetMapping("clearSubsribeCount")
    public ResponseDto<?> clearSubscribeCount(@CookieValue("userInfo") String userInfo,
                                              @RequestParam(value = "recordType", required = false) Integer recordType) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        appletSubscribeCountBiz.clearSubscribeCount(wechatUserId, recordType);
        return new ResponseDto<>();
    }

}