package com.pcloud.book.consumer.advsertising;

import cn.hutool.core.collection.CollUtil;
import com.pcloud.advertising.advertising.dto.AdvertisingSpaceDTO;
import com.pcloud.advertising.advertising.service.AdvertisingService;
import com.pcloud.appcenter.app.dto.AppDto;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.consumer.app.AppConsr;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository("advertisingConsr")
public class AdvertisingConsr {

    private static final Logger LOGGER = LoggerFactory.getLogger(AppConsr.class);

    @Autowired
    private AdvertisingService advertisingService;


    /**
     * 获取小程序广告
     */
    public List<AdvertisingSpaceDTO> getAppletAdvertising() throws BizException {
        List<AdvertisingSpaceDTO> list;
        try {
            ResponseEntity<ResponseDto<List<AdvertisingSpaceDTO>>> appletAdvertisingEntity = advertisingService.getAppletAdvertising();
            list = ResponseHandleUtil.parseList(appletAdvertisingEntity, AdvertisingSpaceDTO.class);
            if(CollUtil.isEmpty(list)){
                return CollUtil.toList();
            }
        } catch (BizException e) {
            LOGGER.warn("获取小程序广告[advertisingService.getAppletAdvertising]:" + e.getMessage(), e);
            throw new BizException(e.getCode(), e.getMessage());
        } catch (Exception e) {
            LOGGER.error("获取小程序广告[advertisingService.getAppletAdvertising]:" + e.getMessage(), e);
            throw new BookBizException(BookBizException.INVOKE_USER_ERROR, "获取小程序广告失败~!");
        }
        return list;
    }

    /**
     * 获取H5广告
     */
    public List<AdvertisingSpaceDTO> getH5Advertising(Long bookId, Long adviserId, Long channelId) {
        List<AdvertisingSpaceDTO> list;
        try {
            ResponseEntity<ResponseDto<List<AdvertisingSpaceDTO>>> appletAdvertisingEntity = advertisingService.getH5Advertising(bookId, adviserId, channelId);
            list = ResponseHandleUtil.parseList(appletAdvertisingEntity, AdvertisingSpaceDTO.class);
            if(CollUtil.isEmpty(list)){
                return CollUtil.toList();
            }
        } catch (BizException e) {
            LOGGER.warn("获取H5广告[advertisingService.getH5Advertising]:" + e.getMessage(), e);
            throw new BizException(e.getCode(), e.getMessage());
        } catch (Exception e) {
            LOGGER.error("获取H5广告[advertisingService.getH5Advertising]:" + e.getMessage(), e);
            throw new BookBizException(BookBizException.INVOKE_USER_ERROR, "获取H5广告失败~!");
        }
        return list;
    }
}
