package com.pcloud.book.consumer.exercisebook;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.exercisebook.dto.CourseModuleDTO;
import com.pcloud.exercisebook.service.ExerciseBookService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

/**
 * @ClassName com.pcloud.book.consumer.exercisebook.ExerciseBookConsr
 * @Author zhuyajie
 * @Description 作业本
 * @Date 2021/3/10 10:23
 * @Version 1.0
 **/
@Slf4j
@Component
public class ExerciseBookConsr {

    @Autowired
    private ExerciseBookService exerciseBookService;

    @ParamLog("查课程模块类型")
    public Map<Integer, CourseModuleDTO> getCourseModuleMap() {
        Map<Integer, CourseModuleDTO> moduleDTOMap = new HashMap<>();
        try {
            moduleDTOMap = ResponseHandleUtil.parseMap(exerciseBookService.getCourseModuleMap(), Integer.class, CourseModuleDTO.class);

        } catch (Exception e) {
            log.error("调用exerciseBookService.getCourseModuleMap失败" + e.getMessage(), e);
        }
        return moduleDTOMap;
    }
}
