package com.pcloud.book.copyright.biz;

import com.pcloud.book.copyright.vo.ServeVO;

import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2018/12/3 12:02
 */
public interface BookAuthServeBiz {

    /**
     * 设置图书授权服务
     */
    void setBookAuthServes(List<ServeVO> serves, Long adviserId, Long bookId, Long channelId);

    /**
     * 服务是否开启版权保护
     * @return
     */
     Map<String, Boolean> isSetServeAuth(Long bookId, Long channelId, Long adviserId, List<Long> serveIds) ;

    /**
     * 服务是否开启版权保护，以及授权后仍付费
     * @return
     */
    Map<String, Boolean> isSetServeAuthPay(Long bookId, Long channelId, Long adviserId, List<Long> serveIds) ;

    /**
     * 获取图书配置得服务
     * @return
     */
    List<ServeVO> listServesByBook(Long bookId, Long channelId, Long adviserId);

    /**
     * 校验服务是否需要授权
     * @return
     */
    Boolean checkIsNeedAuth(Long bookId, Long channelId, Long adviserId, Long serveId, String serveType);

    /**
     * 获取服务是否需要授权
     * @return
     */
    Map<String,Boolean> listIsOpen4ServeIdsAndQrcode(Long sceneId, List<Long> serveIds);

    /**
     * 获取图书是否开启版权保护
     */
    Map<String,Boolean> listIsOpen4ServeIdsAndBookId(Long bookId, Long adviserId, Long channelId, List<Long> serveIds);

    /**
     * 获取图书是否开启授权后仍需付费
     */
    Map<String, Boolean> listIsOpen4AuthorizedPay(Long bookId, Long adviserId, Long channelId, List<Long> serveIds);
}
