package com.pcloud.book.copyright.dao;

import com.pcloud.book.copyright.dto.BookAuthUserDTO;
import com.pcloud.book.copyright.dto.HaveUsedAuthCode;
import com.pcloud.book.copyright.entity.BookAuthUser;
import com.pcloud.book.copyright.vo.BookAuthCodeUserVO;
import com.pcloud.book.copyright.vo.ProvinceTop10VO;
import com.pcloud.book.copyright.vo.SixMonthCountVO;
import com.pcloud.book.copyright.vo.ThirtyDayCountVO;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2018/12/4 15:56
 */
public interface BookAuthUserDao extends BaseDao<BookAuthUser> {
    /**
     * 获取授权用户总数
     */
    BookAuthCodeUserVO getAuthUserCount(Long bookId, Long channelId, Long adviserId, Integer authBookType);

    /**
     * 30天趋势图
     */
    List<ThirtyDayCountVO> listThirtyDay(Map<String,Object> paramMap);

    /**
     * 6个月趋势图
     * @return
     */
    List<SixMonthCountVO> listSixMonth(Map<String,Object> paramMap);

    /**
     * 校验是否已经授权
     */
    Boolean getIsHaveAuth(Long bookId, Long channelId, Long adviserId, List<Long> wechatUserIdList, Integer authBookType);

    /**
     * 根据月份获取授权用户信息
     */
    BookAuthCodeUserVO getAuthUserCountByMonth(Long bookId, Long channelId, Long adviserId, String monthDate);

    /**
     * 获取总的授权用户数据
     */
    BookAuthCodeUserVO getAuthUserTotalCount(List<Long> adviserIds, List<Long> removeAdviserIds);

    /**
     * 获取top10的图书
     */
    List<ProvinceTop10VO> listTop10ByBook(Map<String, Object> paramMap);

    /**
     * 校验用户是否授权
     */
    Boolean checkUserIsHaveAuth(Map<String, Object> paramMap);

    /**
     * 检查给定的书籍是否具有使用过的授权码
     */
    List<HaveUsedAuthCode> checkHaveUsedAuthCode(List<Long> bookIds);

    /**
     * 获取用户授权的具体方式
     */
    BookAuthUser getAuthUser(Long bookId, Long channelId, Long adviserId, Long wechatUserId, Integer authBookType);

    /**
     * 获取使用授权码的用户
     */
    List<BookAuthUserDTO> getByAuthCodeIds(List<Long> authCodeIds);
}
