package com.pcloud.book.cultivate.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;

import java.util.Date;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 宠物小睿基本信息(CultivateRays)实体类
 *
 * @author makejava
 * @since 2021-07-16 13:52:47
 */
@Data
public class CultivateRaysDTO extends BaseDto {
    private static final long serialVersionUID = 703145616367143769L;
    /**
    * 主键
    */
    private Long id;
    /**
    * 用户id
    */
    private Long wechatUserId;
    /**
    * 公众号id
    */
    private Long officialAccountsId;
    /**
    * 收入1数量
    */
    private Integer gains1;
    /**
    * 收入2数量
    */
    private Integer gains2;
    /**
    * 收入3数量
    */
    private Integer gains3;
    /**
    * 当前状态（0饥饿1进食）
    */
    private Integer state;

    @ApiModelProperty("头像")
    private String headPic;
    @ApiModelProperty("昵称")
    private String nickName;
    @ApiModelProperty("上次食物兑换时间")
    private String lastConversionTime;
    @ApiModelProperty("兑换时长")
    private Integer hours;
    /**
     * 进食结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    @ApiModelProperty("是否有宠物")
    private Boolean hasPet;
}