package com.pcloud.book.keywords.facade;

import com.pcloud.book.keywords.vo.*;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author lily
 * @date 2019/4/24 14:31
 */
@Api(description = "关键词设置")
public interface BookKeywordFacade {

    @ApiOperation(value = "设置关键词", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token",  dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "setKeywordVO", value = "设置关键词",  dataType = "List<SetKeywordVO>", paramType = "body")
    })
    @PostMapping("insertKeyword")
    ResponseDto<?> insertKeyword(@RequestHeader("token") String token, @RequestBody List<SetKeywordVO> setKeywordVOs)
            throws BizException, PermissionException;

    @ApiOperation(value = "更新关键词", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token",  dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "updateKeywordVO", value = "修改关键词参数",  dataType = "UpdateKeywordVO", paramType = "body")
    })
    @PostMapping("updateKeyword")
    ResponseDto<?> updateKeyword(@RequestHeader("token") String token, @RequestBody UpdateKeywordVO updateKeywordVO)
            throws BizException, PermissionException;

    @ApiOperation(value = "删除关键词", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token",  dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "deleteKeywordVO", value = "关键词删除VO",  dataType = "DeleteKeywordVO", paramType = "body")
    })
    @PostMapping("deleteKeyword")
    ResponseDto<?> deleteKeyword(@RequestHeader("token") String token, @RequestBody DeleteKeywordVO deleteKeywordVO)
            throws BizException, PermissionException;


    @ApiOperation(value = "获取关键词基本信息", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token",  dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookKeywordId", value = "关键词标识",  dataType = "Long", paramType = "query")
    })
    @GetMapping("getByBookKeyword")
    ResponseDto<KeywordVO> getByBookKeyword(@RequestHeader("token") String token, @RequestParam("bookKeywordId") Long bookKeywordId)
            throws BizException, PermissionException;


    @ApiOperation(value = "设置排序值", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token",  dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "setRankVO", value = "关键词标识",  dataType = "SetRankVO", paramType = "Body")
    })
    @GetMapping("setRank")
    ResponseDto<?> setRank(@RequestHeader("token") String token, @RequestBody SetRankVO setRankVO)
            throws BizException, PermissionException;

    @ApiOperation(value = "根据社群码获取欢迎语", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token",  dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "listKeywordParam", value = "关键词查询参数",  dataType = "ListKeywordParam", paramType = "body")
    })
    @PostMapping("listKeywordsByBookGroup")
    ResponseDto<PageBeanNew<ListKeywordVO>> listKeywordsByBookGroup(@RequestHeader("token") String token, @RequestBody ListKeywordParam listKeywordParam)
            throws BizException;

    @ApiOperation(value = "根据分类获取欢迎语", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token",  dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "listKeywordParam", value = "关键词查询参数",  dataType = "ListKeywordParam", paramType = "body")
    })
    @PostMapping("listKeywordsByClassify")
    ResponseDto<PageBeanNew<ListKeywordVO>> listKeywordsByClassify(@RequestHeader("token") String token, @RequestBody ListKeywordParam listKeywordParam)
            throws BizException;

    @ApiOperation("获取关键词统计列表")
    @GetMapping("getKeywordStatistics")
    ResponseDto<?> getKeywordStatistics(
            @RequestHeader("token") String token,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage,
            @RequestParam("bookGroupId") Long bookGroupId,
            @RequestParam(value = "weixinGroupId",required = false) String weixinGroupId
    ) throws BizException, PermissionException;

    @ApiOperation("获取关键词数量")
    @GetMapping("getKeywordCount")
    ResponseDto<?> getKeywordCount(@RequestHeader("token") String token,@RequestParam("bookGroupId") Long bookGroupId,
                                   @RequestParam(required = false,value = "classifyId") Long classifyId) throws PermissionException;


    @ApiOperation("获取某个群内关键词配置的所有资源")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "qrWeixinParam", value = "查询参数", dataType = "QrWeixinParam", paramType = "body") })
    @PostMapping("getAllServiceByWeixinGroup4Wechat")
    ResponseDto<?> getAllServiceByWeixinGroup4Wechat(@CookieValue("userInfo")String userInfo, @RequestBody QrWeixinParam qrWeixinParam)
            throws BizException, PermissionException;

    @ApiOperation(value = "根据关键词获取要回复的内容", httpMethod = "GET")
    @RequestMapping(value = "getReplyKeyword", method = RequestMethod.GET)
    ResponseDto<String> getReplyKeyword(@RequestParam String content, @RequestParam(value = "weixinGroupId", required = false) String weixinGroupId,
                                                        @RequestParam(value = "wexinGroupName", required = false) String wexinGroupName);

}
