package com.pcloud.book.riddle.dao.impl;

import com.pcloud.book.riddle.dao.RiddleRecordDao;
import com.pcloud.book.riddle.dto.GroupRiddleDTO;
import com.pcloud.book.riddle.dto.UserRankingDTO;
import com.pcloud.book.riddle.entity.RiddleRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：猜谜记录
 * @作者：zhuyajie
 * @创建时间：18:19 2019/7/24
 * @版本：1.0
 */
@Component("riddleRecordDao")
public class RiddleRecordDaoImpl extends BaseDaoImpl<RiddleRecord> implements RiddleRecordDao {


    @Override
    public RiddleRecord getLastRecordByWxGroupId(String wxGroupId, Integer status) {
        Map<String, Object> map = new HashMap<>();
        map.put("wxGroupId", wxGroupId);
        map.put("status", status);
        return getSessionTemplate().selectOne(getStatement("getLastRecordByWxGroupId"), map);
    }

    @Override
    public Integer getCorrectCountByGroup(String wxGroupId, Integer finishCount) {
        Map<String, Object> map = new HashMap<>();
        map.put("wxGroupId", wxGroupId);
        map.put("finishCount", finishCount);
        return getSessionTemplate().selectOne(getStatement("getCorrectCountByGroup"), map);
    }

    @Override
    public GroupRiddleDTO getParticipateCount(String wxGroupId) {
        return getSessionTemplate().selectOne(getStatement("getParticipateCount"), wxGroupId);
    }

    @Override
    public Integer getGroupRanking(String wxGroupId) {
        Integer ranking = getSessionTemplate().selectOne(getStatement("getGroupRanking"), wxGroupId);
        if (null == ranking) {
            ranking = getCorrectGroupCount() + 1;
        }
        return ranking;
    }

    @Override
    public List<UserRankingDTO> getUserRanking(String wxGroupId, Date createTime) {
        Map<String, Object> map = new HashMap<>();
        map.put("wxGroupId", wxGroupId);
        map.put("createTime", createTime);
        return getSessionTemplate().selectList(getStatement("getUserRanking"),map);
    }

    @Override
    public Integer getCorrectCountByTime(String wxGroupId, Date createTime) {
        Map<String, Object> map = new HashMap<>();
        map.put("wxGroupId", wxGroupId);
        map.put("createTime", createTime);
        return getSessionTemplate().selectOne(getStatement("getCorrectCountByTime"), map);
    }

    @Override
    public Integer getOverTime(String wxGroupId) {
        return getSessionTemplate().selectOne(getStatement("getOverTime"), wxGroupId);
    }

    @Override
    public Integer getCorrectGroupCount() {
        return getSessionTemplate().selectOne(getStatement("getCorrectGroupCount"));
    }
}
