package com.pcloud.book.weixinclock.dao.impl;

import com.pcloud.book.weixinclock.dao.WeixinClockDao;
import com.pcloud.book.weixinclock.dto.WeixinClockDto;
import com.pcloud.book.weixinclock.entity.WeixinClock;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Repository;

import java.util.Map;

/**
 * @author 杨涛
 * @description dao层
 * @date 2019/8/14 19:18
 */
@Repository("weixinClockDao")
public class WeixinClockDaoImpl extends BaseDaoImpl<WeixinClock> implements WeixinClockDao {

    /**
     * 删除微信群签到打卡
     * @param paramMap
     * @return
     */
    @Override
    public void deleteWeixinClock(Map<String, Object> paramMap) {
        super.sqlSessionTemplate.delete(getStatement("deleteWeixinClock"),paramMap);
    }

    /**
     * 获取微信群签到打卡信息
     * @param weixinClockId
     * @return
     */
    @Override
    public WeixinClockDto getWeixinClockBaseInfo(Long weixinClockId) {
        return super.sqlSessionTemplate.selectOne(getStatement("getWeixinClockBaseInfo"),weixinClockId);
    }

    @Override
    public WeixinClockDto getByWxGroupId(String wxGroupId) {
        return super.sqlSessionTemplate.selectOne(getStatement("getByWxGroupId"),wxGroupId);
    }
}
