package com.pcloud.book.advertising.dao.impl;

import com.pcloud.book.advertising.dao.AdvertisingBrandDao;
import com.pcloud.book.advertising.dto.AdvertisingBrandDTO;
import com.pcloud.book.advertising.entity.AdvertisingBrand;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：广告品牌方
 * @作者：zhuyajie
 * @创建时间：15:26 2019/9/9
 * @版本：1.0
 */
@Component("advertisingBrandDao")
public class AdvertisingBrandDaoImpl extends BaseDaoImpl<AdvertisingBrand> implements AdvertisingBrandDao{
    @Override
    public List<AdvertisingBrandDTO> getByGroupQrcodeId(Long groupQrcodeId) {
        return getSessionTemplate().selectList(getStatement("getByGroupQrcodeId"), groupQrcodeId);
    }

    @Override
    public List<AdvertisingBrandDTO> getAllBrand() {
        return getSessionTemplate().selectList(getStatement("getAllBrand"));
    }

    @Override
    public Long getBrandIdByUserLoginId(Long userId) {
        //品牌方登录，userId=brandId
        return userId;
    }

    @Override
    public void deleteBrand(Long brandId) {
        getSessionTemplate().update(getStatement("deleteBrand"), brandId);
    }

    @Override
    public AdvertisingBrandDTO getBrandById(Long brandId) {
        return getSessionTemplate().selectOne(getStatement("getBrandById"), brandId);
    }

    @Override
    public Boolean checkBrandNameRepeat(String brandName) {
        return getSessionTemplate().selectOne(getStatement("checkBrandNameRepeat"), brandName);
    }

    @Override
    public Boolean checkLoginNameRepeat(String loginName) {
        return getSessionTemplate().selectOne(getStatement("checkLoginNameRepeat"), loginName);
    }

    @Override
    public AdvertisingBrand getLoginInfo(String loginName) {
        Map<String, Object> map = new HashMap<>();
        map.put("loginName", loginName);
        return getSessionTemplate().selectOne(getStatement("getLoginInfo"), map);
    }

    @Override
    public  Map<Long,AdvertisingBrand> getMapByIds(List<Long> brandIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("brandIds", brandIds);
        return getSessionTemplate().selectMap(getStatement("getMapByIds"), map,"id");
    }
}
