package com.pcloud.book.book.dao.impl;

import com.pcloud.book.book.dao.HotBookDao;
import com.pcloud.book.book.entity.HotBook;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("hotBookDao")
public class HotBookDaoImpl extends BaseDaoImpl<HotBook> implements HotBookDao {
    @Override
    public Integer getMaxSeqNum() {
        return super.getSqlSession().selectOne(super.getStatement("getMaxSeqNum"));
    }

    @Override
    public void updateSeqNum(Long id, Integer seqNum) {
        Map<String,Object> map=new HashMap<>();
        map.put("id",id);
        map.put("seqNum",seqNum);
        super.getSqlSession().update(super.getStatement("updateSeqNum"),map);
    }

    @Override
    public List<HotBook> getHotBookList() {
        return  super.getSqlSession().selectList(super.getStatement("getHotBookList"));
    }
}
