package com.pcloud.book.copyright.dao;

import com.pcloud.book.copyright.dto.BookAuthInfoCountDTO;
import com.pcloud.book.copyright.entity.BookAuthInfo;
import com.pcloud.book.copyright.vo.BookAuthInfoVO;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @author lily
 * @date 2018/12/3 15:17
 */
public interface BookAuthInfoDao extends BaseDao<BookAuthInfo> {
    /**
     * 获取是否有受保护图书
     * @param adviserId 编辑标识
     * @return
     */
    Boolean getIsHaveAuthBook(Long adviserId);

    /**
     * 更新印码位置描述
     */
    void updateLocationDesc(BookAuthInfo bookAuthInfo);

    /**
     * 获取图书正版授权信息
     */
    BookAuthInfoVO getInfoByBook(Long bookId, Long channelId, Long adviserId, Integer authBookType);

    /**
     * 更新图书版权状态
     */
    void updateBookStatus(Long id, Integer bookStatus, Long adviserId);

    /**
     * 更新图书版权基本信息
     */
    void updateBaseInfo(BookAuthInfo bookAuthInfo);

    /**
     *  获取图书授权信息统计数据
     */
    BookAuthInfoCountDTO getBookAuthCount(Long bookId, Long channelId, Long adviserId);

    /**
     * 获取总的数量
     */
    Integer getTotalNum(List<Long> adviserIds, List<Long> removeAdviserIds);
}
