package com.pcloud.book.push.dao.impl;

import com.pcloud.book.push.dao.PushNewsRecordDao;
import com.pcloud.book.push.entity.PushNewsRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/6/14 12:05
 **/
@Repository("pushNewsRecordDao")
public class PushNewsRecordDaoImpl extends BaseDaoImpl<PushNewsRecord> implements PushNewsRecordDao {
    @Override
    public List<PushNewsRecord> getListByGroupIds(List<String> weixinGroupIds) {
        Map<String,Object> map=new HashMap<>();
        map.put("weixinGroupIds",weixinGroupIds);
        return super.getSqlSession().selectList(getStatement("getListByGroupIds"),map);
    }

    @Override
    public void batchInsert(List<PushNewsRecord> pushNewsRecords) {
        super.getSqlSession().insert(getStatement("batchInsert"), pushNewsRecords);
    }
}
