package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.ServeCollectDao;
import com.pcloud.book.applet.dto.CollectionTypeNameAndCountDTO;
import com.pcloud.book.applet.dto.ServeCollectDTO;
import com.pcloud.book.applet.entity.ServeCollect;
import com.pcloud.book.applet.vo.CollectionTypeNameCodeClassifyVO;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * (ServeCollect)表数据库访问层
 *
 * @author makejava
 * @since 2020-09-10 10:44:31
 */
@Repository("serveCollectDaoImpl")
public class ServeCollectDaoImpl extends BaseDaoImpl<ServeCollect> implements ServeCollectDao {

    @Override
    public void cancelCollect(List<Long> ids) {
        getSessionTemplate().update(getStatement("cancelCollect"), ids);
    }

    @Override
    public void deleteInvalidNews(List<Long> newsIds) {
        getSessionTemplate().update(getStatement("deleteInvalidNews"), newsIds);
    }

    @Override
    public List<ServeCollect> getList4RightsSetting(List<ServeCollect> serveCollects) {
        return getSessionTemplate().selectList(getStatement("getList4RightsSetting"), serveCollects);
    }


    @Override
    public List<ServeCollect> getList4RightsSettingByWechatUserId(Long wechatUserId) {
        return getSessionTemplate().selectList(getStatement("getList4RightsSettingByWechatUserId"), wechatUserId);
    }

    @Override
    public List<CollectionTypeNameAndCountDTO> getTypeNameAndCountByWechatId(Long wechatUserId) {
        return super.getSqlSession().selectList(getStatement("getTypeNameAndCountByWechatId"),wechatUserId);
    }

    @Override
    public ServeCollectDTO isCollected(Long wechatUserId, Long serveId) {
        Map<String, Object> paraMap = new HashMap<>();
        paraMap.put("wechatUserId",wechatUserId);
        paraMap.put("serveId",serveId);
        return getSessionTemplate().selectOne(getStatement("isCollected"),paraMap);
    }

    @Override
    public List<CollectionTypeNameCodeClassifyVO> getDistinctTypeCode() {
        return getSessionTemplate().selectList(getStatement("getDistinctTypeCode"));
    }

    @Override
    public void updateTypeName(Map<String, String> paramMap) {
        super.getSqlSession().update(getStatement("updateTypeName"),paramMap);
    }

    @Override
    public List<Long> getAllCollect(Long wechatUserId,String typeCode) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("wechatUserId",wechatUserId);
        paramMap.put("typeCode",typeCode);
        return getSessionTemplate().selectList(getStatement("getAllCollect"), paramMap);
    }

    @Override
    public List<ServeCollectDTO> getList4Collect(List<ServeCollectDTO> serveCollects) {
        return  getSessionTemplate().selectList(getStatement("getList4Collect"), serveCollects);
    }
}