package com.pcloud.book.book.biz.impl;

import com.pcloud.book.book.biz.SearchRecordDisSaleBiz;
import com.pcloud.book.book.dao.SearchRecordDisSaleDao;
import com.pcloud.book.book.entity.SearchRecordDis;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 用户搜索记录（内容去重）(SearchRecordDisSale)表服务实现类
 *
 * @author makejava
 * @since 2020-10-12 16:24:41
 */
@Service("searchRecordDisSaleBiz")
public class SearchRecordDisSaleBizImpl implements SearchRecordDisSaleBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(SearchRecordDisSaleBizImpl.class);

    @Autowired
    private SearchRecordDisSaleDao searchRecordDisSaleDao;

    @Override
    @ParamLog("通过ID查询单条数据")
    public SearchRecordDis getById(Integer id) {
        return searchRecordDisSaleDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = searchRecordDisSaleDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)) {
            return pageBeanNew;
        }
        // 加载其它数据

        return pageBeanNew;
    }

    @Override
    @ParamLog("新增")
    public Long insert(SearchRecordDis searchRecordDisSale) {
        searchRecordDisSaleDao.insert(searchRecordDisSale);
        return searchRecordDisSale.getId();
    }

    @Override
    @ParamLog("修改")
    public void update(SearchRecordDis searchRecordDisSale) {
        if (searchRecordDisSale == null || !NumberUtil.isNumber(searchRecordDisSale.getId())) {
            throw BizException.PARAM_IS_NULL;
        }
        searchRecordDisSaleDao.update(searchRecordDisSale);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Integer id) {
        searchRecordDisSaleDao.deleteById(id);
    }
}