package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletOuterBookDao;
import com.pcloud.book.applet.dto.AppletOuterBookDTO;
import com.pcloud.book.applet.entity.AppletOuterBook;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.applet.dao.impl.AppletOuterBookDaoImpl
 * @Author zhuyajie
 * @Description
 * @Date 2020/8/11 11:53
 * @Version 1.0
 **/
@Component
public class AppletOuterBookDaoImpl extends BaseDaoImpl<AppletOuterBook> implements AppletOuterBookDao {
    @Override
    public List<String> getAllPublish() {
        return getSessionTemplate().selectList(getStatement("getAllPublish"));
    }

    @Override
    public List<AppletOuterBookDTO> listPageOuterBookByBooklistId(Long booklistId, Integer limit) {
        Map<String, Object> map = new HashMap<>();
        map.put("booklistId", booklistId);
        map.put("limit", limit);
        return getSessionTemplate().selectList(getStatement("listPageOuterBookByBooklistId"), map);
    }
}
