package com.pcloud.book.applet.biz.impl;

import com.pcloud.book.applet.biz.BuyBookRequestBiz;
import com.pcloud.book.applet.dao.BuyBookRequestDao;
import com.pcloud.book.applet.dto.BuyBookRequetUserDTO;
import com.pcloud.book.applet.entity.BuyBookRequest;
import com.pcloud.book.consumer.reader.ReaderConsr;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import com.pcloud.readercenter.wechat.entity.WechatUser;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * (BuyBookRequest)表服务实现类
 *
 * @author makejava
 * @since 2020-10-14 19:51:41
 */
@Service("buyBookRequestBiz")
public class BuyBookRequestBizImpl implements BuyBookRequestBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(BuyBookRequestBizImpl.class);

    @Autowired
    private BuyBookRequestDao buyBookRequestDao;
    @Autowired
    private ReaderConsr readerConsr;

    @Override
    @ParamLog("通过ID查询单条数据")
    public BuyBookRequest getById(Long id) {
        return buyBookRequestDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = buyBookRequestDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)) {
            return pageBeanNew;
        }
        // 加载其它数据

        return pageBeanNew;
    }

    @Override
    @ParamLog("新增")
    public Long insert(BuyBookRequest buyBookRequest) {
        buyBookRequestDao.insert(buyBookRequest);
        return buyBookRequest.getId();
    }

    @Override
    @ParamLog("修改")
    public void update(BuyBookRequest buyBookRequest) {
        if (buyBookRequest == null || !NumberUtil.isNumber(buyBookRequest.getId())) {
            throw BizException.PARAM_IS_NULL;
        }
        buyBookRequestDao.update(buyBookRequest);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Long id) {
        buyBookRequestDao.deleteById(id);
    }

    @Override
    public BuyBookRequetUserDTO getUserCount(Integer topCount) {
        List<BuyBookRequest> buyBookRequests =   buyBookRequestDao.getUserCount();
        BuyBookRequetUserDTO buyBookRequetUserDTO = new BuyBookRequetUserDTO();
        List<String> headUrls = new ArrayList<>();
        if (ListUtils.isEmpty(buyBookRequests)) {
            buyBookRequetUserDTO.setUserCount(0);
        } else {
            buyBookRequetUserDTO.setUserCount(buyBookRequests.size());
            List<Long> wechatUserIds = new ArrayList<>();
            wechatUserIds = buyBookRequests.stream().map(e -> e.getWechatUserId()).distinct().collect(Collectors.toList());
            if (!ListUtils.isEmpty(wechatUserIds)) {
                if (wechatUserIds.size() > topCount) {
                    wechatUserIds =  wechatUserIds.subList(0, topCount);
                }
                Map<Long, WechatUser> userList = readerConsr.getUserList(wechatUserIds);
                if (MapUtils.isNotEmpty(userList)) {
                    headUrls = userList.values().stream().map(e -> e.getWechatUserHeadurl()).collect(Collectors.toList());
                }
            }
        }
        buyBookRequetUserDTO.setUserCount(buyBookRequetUserDTO.getUserCount() < 3000 ? 300 + buyBookRequetUserDTO.getUserCount() : buyBookRequetUserDTO.getUserCount());
        buyBookRequetUserDTO.setWechatUserHeadUrl(headUrls);
        return buyBookRequetUserDTO;
    }



}