package com.pcloud.book.giftcoupon.dao.impl;

import com.pcloud.book.giftcoupon.dao.GiftCouponPackageDao;
import com.pcloud.book.giftcoupon.dto.GiftPackageDTO;
import com.pcloud.book.giftcoupon.entity.GiftCouponPackage;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("giftCouponPackageDao")
public class GiftCouponPackageDaoImpl extends BaseDaoImpl<GiftCouponPackage> implements GiftCouponPackageDao  {


    @Override
    public Map<Long,GiftCouponPackage> getMapByIds(List<Long> list) {
        return super.getSqlSession().selectMap(super.getStatement("getMapByIds"), list, "id");
    }

    @Override
    public List<Long> getPackageIdsBy(List<Long> packageIds) {
        Map<String,Object> map=new HashMap<>();
        map.put("packageIds",packageIds);
        return super.getSqlSession().selectList(getStatement("getPackageIdsBy"),map);
    }

    @Override
    public Integer getNoStockCount(List<Long> packageIds) {
        Map<String,Object> map=new HashMap<>();
        map.put("packageIds",packageIds);
        return super.getSqlSession().selectOne(getStatement("getNoStockCount"),map);
    }

    @Override
    public void reduceStock(Long id) {
        Map<String,Object> map=new HashMap<>();
        map.put("id",id);
        super.getSqlSession().update(getStatement("reduceStock"),map);
    }

    @Override
    public void reduceStockBatch(List<Long> packageIds) {
        Map<String,Object> map=new HashMap<>();
        map.put("packageIds",packageIds);
        super.getSqlSession().update(getStatement("reduceStockBatch"),map);
    }

    @Override
    public String getUrlNumberByAddress(String exchangeAddress, Long agentId) {
        Map<String,Object> map = new HashMap<>();
        map.put("agentId", agentId);
        map.put("exchangeAddress", exchangeAddress);
        return getSessionTemplate().selectOne(getStatement("getUrlNumberByAddress"), map);
    }

    @Override
    public Boolean urlNumberExist(String exchangeAddress, String urlNumber, Long id, Long agentId) {
        Map<String, Object> map = new HashMap<>();
        map.put("exchangeAddress", exchangeAddress);
        map.put("urlNumber", urlNumber);
        map.put("id", id);
        map.put("agentId", agentId);
        return getSessionTemplate().selectOne(getStatement("urlNumberExist"), map);
    }

    @Override
    public void batchUpdateGift(Map<String, Object> paramMap) {
        getSessionTemplate().update(getStatement("batchUpdateGift"), paramMap);
    }

    @Override
    public GiftPackageDTO getByPackageId(Long id) {
        return super.getSqlSession().selectOne(getStatement("getByPackageId"),id);
    }

    @Override
    public Integer getByResourceNumber(String resourceNumber,Long packageId) {
        Map<String, Object> map = new HashMap<>();
        map.put("resourceNumber", resourceNumber);
        map.put("packageId", packageId);
        return super.getSqlSession().selectOne(getStatement("getByResourceNumber"),map);
    }

    @Override
    public List<GiftPackageDTO> getGiftByIds(List<Long> packageIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("packageIds", packageIds);
        return super.getSqlSession().selectList(getStatement("getGiftByIds"),map);
    }
}
