package com.pcloud.common.core.constant;

/**
  * 应用类型
  * @author  作者 : lili
  * @date 创建时间：2016年12月2日 上午9:10:49
  * @version 1.0 
  * @return 
  */
public enum AppTypeEnum {

	/**
	 * 一对一辅导
	 */
	CC("cc", com.pcloud.common.core.enums.AppTypeEnum.TUTOR.value),

	/**
	 * 圈子 
	 */
	GROUP("group", com.pcloud.common.core.enums.AppTypeEnum.GROUP.value),
	
	/**
	 * 扫扫看
	 */
	KK("kk", com.pcloud.common.core.enums.AppTypeEnum.KK.value),
	
	/**
	 * 专题
	 */
	ST("st", com.pcloud.common.core.enums.AppTypeEnum.SPECIAL.value),
	
	/**
	 * 背单词
	 */
	WD("wd", com.pcloud.common.core.enums.AppTypeEnum.RECITE_WORD.value),
	
	/**
	 * 数据采集/问卷调查
	 */
	QN("qn", com.pcloud.common.core.enums.AppTypeEnum.DA.value),
	
	/**
	 * 报名
	 */
	REPLY_SCENE("mt", com.pcloud.common.core.enums.AppTypeEnum.BM.value),
	
	/**
	 * 投票
	 */
	VT("vt", com.pcloud.common.core.enums.AppTypeEnum.VOTE.value),
	
	/**
	 * 题库
	 */
	PRETEST("pretest", com.pcloud.common.core.enums.AppTypeEnum.ITEM_BANK.value),
	
	/**
	 * 标准分
	 */
	ZSCORE("zscore", com.pcloud.common.core.enums.AppTypeEnum.ZSCORE.value),
	
	/**
	 * 读书卡片
	 */
	BOOKCARD("card", com.pcloud.common.core.enums.AppTypeEnum.BOOKCARD.value),
	
	/**
	 * 教育表格
	 */
	TB("tb", com.pcloud.common.core.enums.AppTypeEnum.EF.value),

	/**
	 * 直播
	 */
	LIVE("live", com.pcloud.common.core.enums.AppTypeEnum.LIVE.value),

	/**
	 * 打卡
	 */
	CLOCK("clock", com.pcloud.common.core.enums.AppTypeEnum.CLOCK.value),

    /**
     * 伴读魔法箱
     */
    AUDIO_MAGIC("magic", com.pcloud.common.core.enums.AppTypeEnum.AUDIO_MAGIC.value),

	/**
	 * 课件
	 */
	COURSE_WARE("cw", com.pcloud.common.core.enums.AppTypeEnum.COURSE_WARE.value),

	/**
	 * 读者反馈
	 */
	NAIRE("qn", com.pcloud.common.core.enums.AppTypeEnum.NAIRE.value),

	/**
	 * 互动墙
	 */
	INTERACT("interact", com.pcloud.common.core.enums.AppTypeEnum.INTERACT.value),

	/**
	 * 抽奖
	 */
	DRAW("luck", com.pcloud.common.core.enums.AppTypeEnum.DRAW.value),

	/**
	 * 教辅资料包
	 */
	TEACH_RESOURCE("tr", com.pcloud.common.core.enums.AppTypeEnum.TEACH_RESOURCE.value),

	/**
	 * 测试工具
	 */
	TEST("tt", com.pcloud.common.core.enums.AppTypeEnum.TEST.value),

	/**
	 * 愿望单
	 */
	WISH("wish", com.pcloud.common.core.enums.AppTypeEnum.WISH.value),

	/**
	 * 笔顺动图
	 */
	STROKE_ORDER("pen", com.pcloud.common.core.enums.AppTypeEnum.STROKE_ORDER.value),

	/**
	 * 生词听写
	 */
	WORD_DICTATION("dictation", com.pcloud.common.core.enums.AppTypeEnum.WORD_DICTATION.value),

	/**
	 * 配套听力
	 */
	MATCH_LISTEN("mv", com.pcloud.common.core.enums.AppTypeEnum.MATCH_LISTEN.value),

    /**
     * 开通会员
     */
    MEMBER("member", com.pcloud.common.core.enums.AppTypeEnum.MEMBER.value),

	/**
	 * 课文诵读
	 */
	ARTICLE_READING("ar", com.pcloud.common.core.enums.AppTypeEnum.ARTICLE_READING.value),

	/**
	 * 英语随身听
	 */
	ENGLISH_WALKMAN("wm", com.pcloud.common.core.enums.AppTypeEnum.ENGLISH_WALKMAN.value);
	
	/**
	 * 值
	 */
	public final String value;

	public String typeCode;

	/**
	 * 构造
	 * 
	 * @param value
	 */
	private AppTypeEnum(String value) {
		this.value = value;
	}

	private AppTypeEnum(String value, String typeCode) {
		this.value = value;
		this.typeCode = typeCode;
	}

}
