package com.pcloud.common.core.dto.dubbing;

import com.alibaba.fastjson.JSONObject;
import com.pcloud.common.core.dto.dubbing.AudioDTO;

import java.io.Serializable;
import java.util.List;

/**
 * 绘本配音资源DTO
 * 
 * @author：songx
 * @date：2018年12月5日,上午10:07:26
 */
public class DubbingResultDTO implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 2458000180158610651L;

	/**
	 * 来源类型
	 */
	private String fromType;

	/**
	 * 语音文件
	 */
	private List<AudioDTO> speechs;

	/**
	 * 混合音频
	 */
	private AudioDTO mixAudio;

	/**
	 * 应用ID
	 */
	private Long appId;

	/**
	 * 编辑ID
	 */
	private Long adviserId;

	/**
	 * 音乐ID
	 */
	private Long musicId;

	public String getFromType() {
		return fromType;
	}

	public void setFromType(String fromType) {
		this.fromType = fromType;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getAdviserId() {
		return adviserId;
	}

	public void setAdviserId(Long adviserId) {
		this.adviserId = adviserId;
	}

	public Long getMusicId() {
		return musicId;
	}

	public void setMusicId(Long musicId) {
		this.musicId = musicId;
	}

	public List<AudioDTO> getSpeechs() {
		return speechs;
	}

	public void setSpeechs(List<AudioDTO> speechs) {
		this.speechs = speechs;
	}

	public AudioDTO getMixAudio() {
		return mixAudio;
	}

	public void setMixAudio(AudioDTO mixAudio) {
		this.mixAudio = mixAudio;
	}

	@Override
	public String toString() {
		return "DubbingResultDTO : " + JSONObject.toJSONString(this);
	}
}
