/**
 * 
 */
package com.pcloud.common.dto;

import com.alibaba.fastjson.JSON;

/**
 * 
 * @author：songx
 * @date：2019年1月14日,上午9:51:21
 */
public class OssImageDTO {

	/**
	 * 图片所在的OSS路径
	 */
	private String fileUrl;

	/**
	 * 水印内容
	 */
	private String text;

	/**
	 * 水印字体大小(px),取值范围：(0，1000]默认值：40
	 */
	private int size;

	/**
	 * 水印文字颜色
	 * 
	 * 参数的构成必须是：六个十六进制数,默认值：000000黑色
	 */
	private String color;

	/**
	 * 水印文字的透明度,默认值：100， 表示 100%（不透明）取值范围: [0-100]
	 */
	private int t;

	/**
	 * 水印X轴坐标,默认值：10
	 * 
	 * 取值范围：[0 – 4096]
	 * 
	 * 单位：像素（px）
	 */
	private int x;

	/**
	 * 水印Y轴坐标,默认值：10
	 * 
	 * 取值范围：[0 – 4096]
	 * 
	 * 单位：像素(px)
	 */
	private int y;

	/**
	 * 水印所在的位置，取值范围：[nw,north,ne,west,center,east,sw,south,se]
	 */
	private String g;

	/**
	 * 水印文字的阴影透明度
	 */
	private int shadow;

	public int getShadow() {
		return shadow;
	}

	public void setShadow(int shadow) {
		this.shadow = shadow;
	}

	public String getFileUrl() {
		return fileUrl;
	}

	public void setFileUrl(String fileUrl) {
		this.fileUrl = fileUrl;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}

	public int getSize() {
		return size;
	}

	public void setSize(int size) {
		this.size = size;
	}

	public String getColor() {
		return color;
	}

	public void setColor(String color) {
		this.color = color;
	}

	public int getT() {
		return t;
	}

	public void setT(int t) {
		this.t = t;
	}

	public int getX() {
		return x;
	}

	public void setX(int x) {
		this.x = x;
	}

	public int getY() {
		return y;
	}

	public void setY(int y) {
		this.y = y;
	}

	public String getG() {
		return g;
	}

	public void setG(String g) {
		this.g = g;
	}

	@Override
	public String toString() {
		return "OssImageDTO -> " + JSON.toJSONString(this);
	}

}
